/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.AlterTableTask;
import io.crate.execution.ddl.tables.DropConstraintRequest;
import io.crate.metadata.NodeContext;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDropConstraint
extends AbstractDDLTransportAction<DropConstraintRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private static final AlterTableTask.AlterTableOperator<DropConstraintRequest> DROP_CONSTRAINT_OPERATOR = (req, docTableInfo, builder, nodeContext, fulltextAnalyzerResolver) -> docTableInfo.dropConstraint(req.constraintName());
    private final NodeContext nodeContext;

    @Inject
    public TransportDropConstraint(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, NodeContext nodeContext) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropConstraintRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-constraint");
        this.nodeContext = nodeContext;
    }

    @Override
    public ClusterStateTaskExecutor<DropConstraintRequest> clusterStateTaskExecutor(DropConstraintRequest request) {
        return new AlterTableTask<DropConstraintRequest>(this.nodeContext, request.relationName(), null, DROP_CONSTRAINT_OPERATOR);
    }

    @Override
    public ClusterBlockException checkBlock(DropConstraintRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table/drop_constraint";

        private Action() {
            super(NAME);
        }
    }
}

