/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.DropPartitionsRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportDropPartitionsAction
extends AbstractDDLTransportAction<DropPartitionsRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final DDLClusterStateTaskExecutor<DropPartitionsRequest> executor;

    @Inject
    public TransportDropPartitionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, final MetadataDeleteIndexService deleteIndexService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropPartitionsRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-table-partitions");
        this.executor = new DDLClusterStateTaskExecutor<DropPartitionsRequest>(this){

            @Override
            protected ClusterState execute(ClusterState currentState, DropPartitionsRequest request) {
                RelationMetadata.Table table = (RelationMetadata.Table)currentState.metadata().getRelation(request.relationName());
                if (table == null) {
                    throw new RelationUnknown(request.relationName());
                }
                Collection<Index> indices = TransportDropPartitionsAction.getIndices(currentState, request, IndexMetadata::getIndex);
                if (indices.isEmpty()) {
                    return currentState;
                }
                return deleteIndexService.deleteIndices(currentState, indices);
            }
        };
    }

    private static <T> Collection<T> getIndices(ClusterState currentState, DropPartitionsRequest request, Function<IndexMetadata, T> mapFunction) {
        Collection<Object> indices;
        if (request.partitions().isEmpty()) {
            indices = currentState.metadata().getIndices(request.relationName(), List.of(), false, mapFunction);
        } else {
            indices = new HashSet();
            for (PartitionName partition : request.partitions()) {
                indices.addAll(currentState.metadata().getIndices(request.relationName(), partition.values(), false, mapFunction));
            }
        }
        return indices;
    }

    @Override
    public ClusterStateTaskExecutor<DropPartitionsRequest> clusterStateTaskExecutor(DropPartitionsRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(DropPartitionsRequest request, ClusterState state) {
        String[] indexNames = (String[])TransportDropPartitionsAction.getIndices(state, request, im -> im.getIndex().getName()).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indexNames);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        public static final String NAME = "internal:crate:sql/table/drop-partitions";

        private Action() {
            super(NAME);
        }
    }
}

