/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DropTableClusterStateTaskExecutor;
import java.util.List;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDropTable
extends AbstractDDLTransportAction<DropTableRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final DropTableClusterStateTaskExecutor executor;

    @Inject
    public TransportDropTable(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataDeleteIndexService deleteIndexService, DDLClusterStateService ddlClusterStateService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropTableRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-table");
        this.executor = new DropTableClusterStateTaskExecutor(deleteIndexService, ddlClusterStateService);
    }

    @Override
    public ClusterStateTaskExecutor<DropTableRequest> clusterStateTaskExecutor(DropTableRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(DropTableRequest request, ClusterState state) {
        String[] indexUUIDS = (String[])state.metadata().getIndices(request.tableIdent(), List.of(), false, imd -> imd.getIndex().getUUID()).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indexUUIDS);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table/drop";

        private Action() {
            super(NAME);
        }
    }
}

