/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.OpenTableRequest;
import io.crate.execution.ddl.tables.TransportCloseTable;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.OpenTableClusterStateTaskExecutor;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportOpenTable
extends AbstractDDLTransportAction<OpenTableRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final OpenTableClusterStateTaskExecutor openExecutor;

    @Inject
    public TransportOpenTable(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, DDLClusterStateService ddlClusterStateService, MetadataUpgradeService metadataIndexUpgradeService, IndicesService indexServices) {
        super(ACTION.name(), transportService, clusterService, threadPool, OpenTableRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "open-table-or-partition");
        this.openExecutor = new OpenTableClusterStateTaskExecutor(allocationService, ddlClusterStateService, metadataIndexUpgradeService, indexServices);
    }

    @Override
    public ClusterStateTaskExecutor<OpenTableRequest> clusterStateTaskExecutor(OpenTableRequest request) {
        return this.openExecutor;
    }

    @Override
    protected ClusterBlockException checkBlock(OpenTableRequest request, ClusterState state) {
        RelationName relation = request.relation();
        if (TransportCloseTable.isEmptyPartitionedTable(relation, state)) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
        String[] indexNames = (String[])state.metadata().getIndices(relation, request.partitionValues(), true, imd -> imd.getIndex().getName()).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indexNames);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table_or_partition/open_close";

        private Action() {
            super(NAME);
        }
    }
}

