/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.tables.RenameTableRequest;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.RenameTableClusterStateExecutor;
import io.crate.metadata.view.ViewsMetadata;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRenameTable
extends TransportMasterNodeAction<RenameTableRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final RenameTableClusterStateExecutor executor;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public TransportRenameTable(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        super(ACTION.name(), transportService, clusterService, threadPool, RenameTableRequest::new);
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
        this.executor = new RenameTableClusterStateExecutor(allocationService, ddlClusterStateService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(final RenameTableRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        final AtomicReference<Object> newIndexUUIDs = new AtomicReference<Object>(null);
        ActionListener<AcknowledgedResponse> waitForShardsListener = this.activeShardsObserver.waitForShards(listener, request.timeout(), () -> this.logger.info("Renamed a relation, but the operation timed out waiting for enough shards to become available"), newIndexUUIDs::get);
        this.clusterService.submitStateUpdateTask("rename-table", new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, Priority.HIGH, (AckedRequest)request, waitForShardsListener){
            final /* synthetic */ TransportRenameTable this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState updatedState = this.this$0.executor.execute(currentState, request);
                newIndexUUIDs.set((String[])updatedState.metadata().getIndices(request.targetName(), List.of(), false, imd -> imd.getState() == IndexMetadata.State.OPEN ? imd.getIndex().getUUID() : null).toArray(String[]::new));
                return updatedState;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(RenameTableRequest request, ClusterState state) {
        ViewsMetadata views = (ViewsMetadata)state.metadata().custom("views");
        if (views != null && views.contains(request.sourceName())) {
            return null;
        }
        boolean strict = !request.isPartitioned();
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, (String[])state.metadata().getIndices(request.sourceName(), List.of(), strict, imd -> imd.getIndex().getName()).toArray(String[]::new));
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table/rename";

        private Action() {
            super(NAME);
        }
    }
}

