/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.Streamer;
import io.crate.execution.dml.ArrayOfObjectIndexer;
import io.crate.execution.dml.DynamicIndexer;
import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.scalar.NumNullTermsPerDocQuery;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.table.TableInfo;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayIndexer<T>
implements ValueIndexer<List<T>> {
    public static final Version ARRAY_LENGTH_FIELD_SUPPORTED_VERSION = Version.V_5_9_0;
    public static final String ARRAY_VALUES_FIELD_PREFIX = "_array_values_";
    public static final String ARRAY_LENGTH_FIELD_PREFIX = "_array_length_";
    protected final ValueIndexer<T> innerIndexer;
    protected final Streamer<List<T>> bytesConverter;
    protected final String arrayLengthFieldName;
    protected final Reference reference;

    public static Query arrayLengthTermQuery(Reference arrayRef, int length, Function<ColumnIdent, Reference> getRef) {
        return IntPoint.newExactQuery((String)ArrayIndexer.toArrayLengthFieldName(arrayRef, getRef), (int)length);
    }

    public static Query arrayLengthRangeQuery(Reference arrayRef, int includeLower, int includeUpper, Function<ColumnIdent, Reference> getRef) {
        return IntPoint.newRangeQuery((String)ArrayIndexer.toArrayLengthFieldName(arrayRef, getRef), (int)includeLower, (int)includeUpper);
    }

    public static Query arrayLengthExistsQuery(Reference arrayRef, Function<ColumnIdent, Reference> getRef) {
        return new FieldExistsQuery(ArrayIndexer.toArrayLengthFieldName(arrayRef, getRef));
    }

    public static Query arraysWithoutNullElementsQuery(Reference arrayRef, Function<ColumnIdent, Reference> getRef) {
        return NumNullTermsPerDocQuery.of(arrayRef, getRef, nullElementCount -> nullElementCount == 0);
    }

    public static String toArrayLengthFieldName(Reference arrayRef, Function<ColumnIdent, Reference> getRef) {
        DataType<?> valueType = Optional.ofNullable(getRef.apply(arrayRef.column())).orElse(arrayRef).valueType();
        if (!arrayRef.valueType().equals(valueType)) {
            ColumnIdent topMostObjectArray = null;
            for (ColumnIdent columnIdent = arrayRef.column(); columnIdent != null; columnIdent = columnIdent.getParent()) {
                if (!TableInfo.IS_OBJECT_ARRAY.test(getRef.apply(columnIdent).valueType())) continue;
                topMostObjectArray = columnIdent;
            }
            assert (topMostObjectArray != null) : "When the arrayRef is a ReadReference it must be a child of an object array type";
            return ARRAY_LENGTH_FIELD_PREFIX + getRef.apply(topMostObjectArray).storageIdentLeafName();
        }
        return ARRAY_LENGTH_FIELD_PREFIX + arrayRef.storageIdentLeafName();
    }

    public static <T> ValueIndexer<T> of(Reference arrayRef, Function<ColumnIdent, Reference> getRef) {
        DataType<?> innerMostType = ArrayType.unnest(arrayRef.valueType());
        StorageSupport<?> innerMostStorageSupport = innerMostType.storageSupportSafe();
        ValueIndexer<?> childIndexer = innerMostStorageSupport.valueIndexer(arrayRef.ident().tableIdent(), arrayRef, getRef);
        for (int i = 0; i < ArrayType.dimensions(arrayRef.valueType()) - 1; ++i) {
            childIndexer = new ArrayIndexer(childIndexer, getRef, arrayRef);
        }
        return innerMostType instanceof ObjectType ? new ArrayOfObjectIndexer(childIndexer, getRef, arrayRef) : new ArrayIndexer(childIndexer, getRef, arrayRef);
    }

    protected ArrayIndexer(ValueIndexer<T> innerIndexer, Function<ColumnIdent, Reference> getRef, Reference reference) {
        this.innerIndexer = innerIndexer;
        this.bytesConverter = reference.valueType().streamer();
        this.reference = reference;
        this.arrayLengthFieldName = ArrayIndexer.toArrayLengthFieldName(reference, getRef);
    }

    @Override
    public void indexValue(@NotNull List<T> values, IndexDocumentBuilder docBuilder) throws IOException {
        docBuilder.translogWriter().startArray();
        IndexDocumentBuilder nestedDocBuilder = docBuilder.noStoredField().noArrayLengthField();
        for (T value : values) {
            if (value == null) {
                docBuilder.translogWriter().writeNull();
                continue;
            }
            this.innerIndexer.indexValue(value, nestedDocBuilder);
        }
        if (docBuilder.maybeAddArrayLengthField()) {
            docBuilder.addField((IndexableField)new IntField(this.arrayLengthFieldName, values.size(), Field.Store.NO));
        }
        docBuilder.translogWriter().endArray();
        if (docBuilder.maybeAddStoredField()) {
            String storedField = ARRAY_VALUES_FIELD_PREFIX + this.reference.storageIdent();
            BytesRef arrayBytes = this.arrayToBytes(values, docBuilder).toBytesRef();
            docBuilder.addField((IndexableField)new StoredField(storedField, arrayBytes));
        }
    }

    protected BytesReference arrayToBytes(List<T> values, IndexDocumentBuilder docBuilder) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            output.setVersion(docBuilder.getTableVersionCreated());
            this.bytesConverter.writeValueTo(output, values);
            BytesReference bytesReference = output.bytes();
            return bytesReference;
        }
    }

    @Override
    public void collectSchemaUpdates(@Nullable List<T> values, Consumer<? super Reference> onDynamicColumn, ValueIndexer.Synthetics synthetics) throws IOException {
        if (values != null) {
            if (DataTypes.isArrayOfNulls(this.reference.valueType())) {
                this.handleNullArrayUpcast(values, onDynamicColumn, synthetics);
            } else {
                for (T value : values) {
                    if (value == null) continue;
                    this.innerIndexer.collectSchemaUpdates(value, onDynamicColumn, synthetics);
                }
            }
        }
    }

    private void handleNullArrayUpcast(List<?> values, Consumer<? super Reference> onDynamicColumn, ValueIndexer.Synthetics synthetics) throws IOException {
        DataType<?> type = DataTypes.typeFromList(values, true);
        if (DataTypes.isArrayOfNulls(type)) {
            return;
        }
        Reference ref = DynamicIndexer.buildReference(this.reference.ident(), type, this.reference.position(), this.reference.oid());
        onDynamicColumn.accept(ref);
        StorageSupport<?> storageSupport = type.storageSupport();
        assert (storageSupport != null);
        ValueIndexer<?> indexer = storageSupport.valueIndexer(ref.ident().tableIdent(), ref, columnIdent -> null);
        indexer.collectSchemaUpdates(values, onDynamicColumn, synthetics);
    }

    @Override
    public void updateTargets(Function<ColumnIdent, Reference> getRef) {
        this.innerIndexer.updateTargets(getRef);
    }

    @Override
    public String storageIdentLeafName() {
        return this.reference.storageIdentLeafName();
    }
}

