/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.execution.dml.ShardResponse;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class BulkResponse {
    private final int size;
    private final long[] rowCounts;
    @Nullable
    private final Throwable[] failures;

    public BulkResponse(int size) {
        this.size = size;
        this.rowCounts = new long[size];
        this.failures = new Throwable[size];
    }

    public BulkResponse update(ShardResponse.CompressedResult result, IntCollection items) {
        for (IntCursor c : items) {
            int itemLocation = c.index;
            int resultIdx = c.value;
            if (result.successfulWrites(itemLocation)) {
                this.incrementRowCount(resultIdx);
                continue;
            }
            if (!result.failed(itemLocation)) continue;
            this.setFailure(resultIdx, result.failure(itemLocation));
        }
        return this;
    }

    public BulkResponse update(int idx, @Nullable Long rowCount, @Nullable Throwable failure) {
        if (failure == null) {
            assert (rowCount != null) : "rowCount must not be null if failure is null";
            this.rowCounts[idx] = rowCount;
        } else {
            this.setFailure(idx, failure);
        }
        return this;
    }

    public void incrementRowCount(int idx) {
        int n = idx;
        this.rowCounts[n] = this.rowCounts[n] + 1L;
    }

    public void setFailure(int idx, Throwable throwable) {
        this.rowCounts[idx] = -2L;
        this.failures[idx] = throwable;
    }

    public long rowCount(int idx) {
        return this.rowCounts[idx];
    }

    @Nullable
    public Throwable failure(int idx) {
        return this.failures[idx];
    }

    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public long[] rowCounts() {
        return this.rowCounts;
    }
}

