/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

public class FloatIndexer
implements ValueIndexer<Float> {
    private final Reference ref;
    private final String name;

    public FloatIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull Float value, IndexDocumentBuilder docBuilder) throws IOException {
        float floatValue = value.floatValue();
        if (this.ref.hasDocValues() && this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new FloatField(this.name, floatValue, Field.Store.NO));
        } else {
            if (this.ref.indexType() != IndexType.NONE) {
                docBuilder.addField((IndexableField)new FloatPoint(this.name, new float[]{floatValue}));
            }
            if (this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new SortedNumericDocValuesField(this.name, (long)NumericUtils.floatToSortableInt((float)floatValue)));
            } else {
                if (docBuilder.maybeAddStoredField()) {
                    docBuilder.addField((IndexableField)new StoredField(this.name, floatValue));
                }
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
        }
        docBuilder.translogWriter().writeValue(floatValue);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }
}

