/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.jetbrains.annotations.NotNull;

public class LongIndexer
implements ValueIndexer<Long> {
    private final Reference ref;
    private final String name;

    public LongIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull Long value, IndexDocumentBuilder docBuilder) throws IOException {
        long longValue = value;
        if (longValue == Long.MAX_VALUE || longValue == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Value " + longValue + " exceeds allowed range for column of type bigint");
        }
        if (this.ref.hasDocValues() && this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new LongField(this.name, longValue, Field.Store.NO));
        } else {
            if (this.ref.indexType() != IndexType.NONE) {
                docBuilder.addField((IndexableField)new LongPoint(this.name, new long[]{longValue}));
            }
            if (this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new SortedNumericDocValuesField(this.name, longValue));
            } else {
                if (docBuilder.maybeAddStoredField()) {
                    docBuilder.addField((IndexableField)new StoredField(this.name, longValue));
                }
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
        }
        docBuilder.translogWriter().writeValue(longValue);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }
}

