/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.TranslogWriter;
import io.crate.execution.dml.XContentTranslogWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.elasticsearch.common.bytes.BytesReference;

class SidecarTranslogWriter
implements TranslogWriter {
    private final TranslogWriter inner;
    private final TranslogWriter sidecar;

    SidecarTranslogWriter(TranslogWriter inner, String oid) {
        this.inner = inner;
        this.sidecar = new XContentTranslogWriter();
        try {
            this.sidecar.writeFieldName(oid);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void startArray() throws IOException {
        this.inner.startArray();
        this.sidecar.startArray();
    }

    @Override
    public void endArray() throws IOException {
        this.inner.endArray();
        this.sidecar.endArray();
    }

    @Override
    public void startObject() throws IOException {
        this.inner.startObject();
        this.sidecar.startObject();
    }

    @Override
    public void endObject() throws IOException {
        this.inner.endObject();
        this.sidecar.endObject();
    }

    @Override
    public void writeFieldName(String fieldName) throws IOException {
        this.inner.writeFieldName(fieldName);
        this.sidecar.writeFieldName(fieldName);
    }

    @Override
    public void writeNull() throws IOException {
        this.inner.writeNull();
        this.sidecar.writeNull();
    }

    @Override
    public void writeValue(Object value) throws IOException {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public void writeValue(String value) throws IOException {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public void writeValue(int value) throws IOException {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public void writeValue(long value) throws IOException {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public void writeValue(float value) throws IOException {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public void writeValue(double value) throws IOException {
        this.inner.writeValue(value);
        this.sidecar.writeValue(value);
    }

    @Override
    public BytesReference bytes() throws IOException {
        return this.sidecar.bytes();
    }
}

