/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.common.collections.Lists;
import io.crate.common.collections.Maps;
import io.crate.execution.dml.FulltextIndexer;
import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.Indexer;
import io.crate.execution.dml.TranslogMappingUpdateException;
import io.crate.execution.dml.TranslogWriter;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParsedDocument;

public class TranslogIndexer {
    private final Map<String, ColumnIndexer<?>> indexers = new HashMap();
    private final boolean ignoreUnknownColumns;
    private final SourceParser sourceParser;
    private final Version shardCreatedVersion;
    private final List<Indexer.IndexColumn<IndexInput>> indexColumns;

    public TranslogIndexer(DocTableInfo table, Version shardCreatedVersion) {
        this.sourceParser = new SourceParser(table.lookupNameBySourceKey(), false);
        for (Reference ref : table.rootColumns()) {
            StorageSupport<?> storageSupport = ref.valueType().storageSupport();
            if (storageSupport != null) {
                ColumnIndexer columnIndexer = new ColumnIndexer(ref.valueType(), storageSupport.valueIndexer(table.ident(), ref, table::getReference));
                this.indexers.put(ref.column().name(), columnIndexer);
            }
            if (ref.granularity() != RowGranularity.DOC) continue;
            this.sourceParser.register(DocReferences.toDocLookup(ref).column(), ref.valueType());
        }
        this.indexColumns = Indexer.buildIndexColumns(table.indexColumns(), table::getReference, reference -> new IndexInput(reference.column()));
        this.ignoreUnknownColumns = table.columnPolicy() != ColumnPolicy.STRICT;
        this.shardCreatedVersion = shardCreatedVersion;
    }

    public TranslogIndexer(BlobTableInfo table, Version shardCreatedVersion) {
        this.sourceParser = new SourceParser(s -> s, false);
        for (Reference ref : table.rootColumns()) {
            StorageSupport<?> storageSupport = ref.valueType().storageSupport();
            if (storageSupport == null) continue;
            ColumnIndexer columnIndexer = new ColumnIndexer(ref.valueType(), storageSupport.valueIndexer(table.ident(), ref, table::getReference));
            this.indexers.put(ref.column().name(), columnIndexer);
        }
        this.indexColumns = List.of();
        this.ignoreUnknownColumns = false;
        this.shardCreatedVersion = shardCreatedVersion;
    }

    public ParsedDocument index(String id, BytesReference source) {
        try {
            return this.populateLuceneFields(source).build(id);
        }
        catch (IOException | UncheckedIOException e) {
            throw new MapperParsingException("Error parsing translog source", e);
        }
    }

    private IndexDocumentBuilder populateLuceneFields(BytesReference source) throws IOException {
        Map<String, Object> docMap = this.sourceParser.parse(source, !this.ignoreUnknownColumns);
        IndexDocumentBuilder docBuilder = new IndexDocumentBuilder(TranslogWriter.wrapBytes(source), columnIdent -> null, Map.of(), this.shardCreatedVersion);
        for (Map.Entry<String, Object> entry : docMap.entrySet()) {
            String column = entry.getKey();
            ColumnIndexer<?> indexer = this.indexers.get(column);
            if (indexer == null) {
                if (TranslogIndexer.isEmpty(entry.getValue())) continue;
                throw new TranslogMappingUpdateException("Unknown column in translog entry: " + String.valueOf(entry));
            }
            Object castValue = TranslogIndexer.valueForInsert(indexer.dataType, entry.getValue());
            if (castValue != null) {
                indexer.valueIndexer.indexValue(castValue, docBuilder);
            }
            entry.setValue(castValue);
        }
        TranslogIndexer.addIndexColumns(this.indexColumns, docMap, docBuilder);
        return docBuilder;
    }

    private static void addIndexColumns(List<Indexer.IndexColumn<IndexInput>> indexColumns, Map<String, Object> docMap, IndexDocumentBuilder docBuilder) {
        for (Indexer.IndexColumn<IndexInput> indexColumn : indexColumns) {
            String fqn = indexColumn.reference().storageIdent();
            for (IndexInput input : indexColumn.inputs()) {
                Object value = input.value(docMap);
                if (value == null) continue;
                if (value instanceof Iterable) {
                    Iterable it = (Iterable)value;
                    for (Object val : it) {
                        if (val == null) continue;
                        Field field = new Field(fqn, (CharSequence)val.toString(), (IndexableFieldType)FulltextIndexer.FIELD_TYPE);
                        docBuilder.addField((IndexableField)field);
                    }
                    continue;
                }
                Field field = new Field(fqn, (CharSequence)value.toString(), (IndexableFieldType)FulltextIndexer.FIELD_TYPE);
                docBuilder.addField((IndexableField)field);
            }
        }
    }

    private static boolean isEmpty(Object value) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, Map.class}, (Object)object, n)) {
            case -1: {
                return true;
            }
            case 0: {
                List l = (List)object;
                if (l.isEmpty()) {
                    return true;
                }
                return l.stream().allMatch(TranslogIndexer::isEmpty);
            }
            case 1: {
                Map m = (Map)object;
                for (Map.Entry entry : m.entrySet()) {
                    if (TranslogIndexer.isEmpty(entry.getValue())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static <T> T valueForInsert(DataType<T> valueType, Object value) {
        return valueType.valueForInsert(valueType.sanitizeValueLenient(value));
    }

    private record ColumnIndexer<T>(DataType<T> dataType, ValueIndexer<Object> valueIndexer) {
    }

    private static class IndexInput {
        private final List<String> fullPath;

        public IndexInput(ColumnIdent columnIdent) {
            this.fullPath = Lists.concat((Object)columnIdent.name(), columnIdent.path());
        }

        public Object value(Map<String, Object> sourceMap) {
            return Maps.getByPath(sourceMap, this.fullPath);
        }
    }
}

