/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.JobKilledException;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillAllListener;
import io.crate.execution.jobs.kill.KillableCallable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardAction<Request extends ShardRequest<Request, Item>, ReplicaReq extends ShardRequest<ReplicaReq, ReplicaItem>, Item extends ShardRequest.Item, ReplicaItem extends ShardRequest.Item>
extends TransportWriteAction<Request, ReplicaReq, ShardResponse>
implements KillAllListener {
    private final ConcurrentHashMap<TaskId, KillableCallable<?>> activeOperations = new ConcurrentHashMap();
    private final TasksService tasksService;
    private final CircuitBreakerService circuitBreakerService;

    protected TransportShardAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, TasksService tasksService, ThreadPool threadPool, ShardStateAction shardStateAction, CircuitBreakerService circuitBreakerService, Writeable.Reader<Request> reader, Writeable.Reader<ReplicaReq> replicaReader) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, reader, replicaReader, "write", false);
        this.circuitBreakerService = circuitBreakerService;
        this.tasksService = tasksService;
    }

    @Override
    protected ShardResponse newResponseInstance(StreamInput in) throws IOException {
        return new ShardResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(Request request, final IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaReq, ShardResponse>> listener) {
        if (this.tasksService.recentlyFailed(((ShardRequest)request).jobId())) {
            listener.onFailure(JobKilledException.of("Job killed"));
            return;
        }
        try {
            KillableCallable callable = new KillableCallable<TransportWriteAction.WritePrimaryResult<ReplicaReq, ShardResponse>>(this, ((ShardRequest)request).jobId(), (ShardRequest)request){
                final /* synthetic */ ShardRequest val$request;
                final /* synthetic */ TransportShardAction this$0;
                {
                    this.val$request = shardRequest;
                    this.this$0 = this$0;
                    super(jobId);
                }

                @Override
                public TransportWriteAction.WritePrimaryResult<ReplicaReq, ShardResponse> call() throws Exception {
                    return this.this$0.processRequestItems(primary, this.val$request, this.killed);
                }
            };
            listener.onResponse((TransportReplicationAction.PrimaryResult)this.withActiveOperation((ShardRequest<?, ?>)request, callable));
        }
        catch (Throwable t) {
            listener.onFailure(Exceptions.toRuntimeException((Throwable)t));
        }
    }

    protected TransportWriteAction.WriteReplicaResult shardOperationOnReplica(final ReplicaReq replicaRequest, final IndexShard indexShard) {
        KillableCallable<TransportWriteAction.WriteReplicaResult> callable = new KillableCallable<TransportWriteAction.WriteReplicaResult>(this, ((ShardRequest)replicaRequest).jobId()){
            final /* synthetic */ TransportShardAction this$0;
            {
                this.this$0 = this$0;
                super(jobId);
            }

            @Override
            public TransportWriteAction.WriteReplicaResult call() throws Exception {
                return this.this$0.processRequestItemsOnReplica(indexShard, replicaRequest);
            }
        };
        return this.withActiveOperation((ShardRequest<?, ?>)replicaRequest, (KillableCallable)callable);
    }

    private <WrapperResponse> WrapperResponse withActiveOperation(ShardRequest<?, ?> request, KillableCallable<WrapperResponse> callable) {
        CircuitBreaker breaker = this.circuitBreakerService.getBreaker("query");
        long ramBytesUsed = request.ramBytesUsed();
        breaker.addEstimateBytesAndMaybeBreak(ramBytesUsed, "upsert request");
        TaskId id = request.getParentTask();
        this.activeOperations.put(id, callable);
        try {
            Object v = callable.call();
            return (WrapperResponse)v;
        }
        catch (Throwable t) {
            throw Exceptions.toRuntimeException((Throwable)t);
        }
        finally {
            this.activeOperations.remove(id, callable);
            breaker.addWithoutBreaking(-ramBytesUsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllJobs() {
        ConcurrentHashMap<TaskId, KillableCallable<?>> concurrentHashMap = this.activeOperations;
        synchronized (concurrentHashMap) {
            for (KillableCallable<?> callable : this.activeOperations.values()) {
                callable.kill(new InterruptedException("Job killed"));
            }
            this.activeOperations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killJob(UUID jobId) {
        ConcurrentHashMap<TaskId, KillableCallable<?>> concurrentHashMap = this.activeOperations;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<TaskId, KillableCallable<?>>> iterator = this.activeOperations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TaskId, KillableCallable<?>> entry = iterator.next();
                KillableCallable<?> killable = entry.getValue();
                if (!killable.jobId().equals(jobId)) continue;
                iterator.remove();
                killable.kill(new InterruptedException("Job killed"));
            }
        }
    }

    protected abstract TransportWriteAction.WritePrimaryResult<ReplicaReq, ShardResponse> processRequestItems(IndexShard var1, Request var2, AtomicBoolean var3) throws InterruptedException, IOException;

    protected abstract TransportWriteAction.WriteReplicaResult processRequestItemsOnReplica(IndexShard var1, ReplicaReq var2) throws IOException;
}

