/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.metadata.Reference;
import io.crate.metadata.settings.SessionSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class UpsertReplicaRequest
extends ShardRequest<UpsertReplicaRequest, Item> {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(UpsertReplicaRequest.class);
    private final List<Reference> columns;
    private final SessionSettings sessionSettings;

    public UpsertReplicaRequest(ShardId shardId, UUID jobId, SessionSettings sessionSettings, List<Reference> columns, List<Item> items) {
        super(shardId, jobId);
        this.sessionSettings = sessionSettings;
        this.columns = columns;
        this.items = items;
    }

    public static UpsertReplicaRequest readFrom(StreamInput in) throws IOException {
        if (in.getVersion().onOrBefore(Version.V_5_10_10)) {
            ShardUpsertRequest request = new ShardUpsertRequest(in);
            return new UpsertReplicaRequest(request.shardId(), request.jobId(), request.sessionSettings(), Arrays.asList(request.insertColumns()), Lists.mapLazy(request.items(), Item::of));
        }
        return new UpsertReplicaRequest(in);
    }

    private UpsertReplicaRequest(StreamInput in) throws IOException {
        super(in);
        this.sessionSettings = new SessionSettings(in);
        this.columns = in.readList(Reference::fromStream);
        int numItems = in.readVInt();
        this.items = new ArrayList(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.items.add(new Item(in, this.columns));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrBefore(Version.V_5_10_10)) {
            Reference[] insertColumns = (Reference[])this.columns.toArray(Reference[]::new);
            ShardUpsertRequest shardUpsertRequest = new ShardUpsertRequest(this.shardId, this.jobId(), true, ShardUpsertRequest.DuplicateKeyAction.IGNORE, this.sessionSettings, null, insertColumns, null);
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)this.items.get(i);
                ShardUpsertRequest.Item primaryItem = ShardUpsertRequest.Item.forInsert(item.id(), item.pkValues(), -1L, insertColumns, item.insertValues(), null, 0L);
                primaryItem.seqNo = item.seqNo();
                primaryItem.primaryTerm = item.primaryTerm();
                primaryItem.version = item.version();
                shardUpsertRequest.add(i, primaryItem);
            }
            shardUpsertRequest.writeTo(out);
            return;
        }
        super.writeTo(out);
        this.sessionSettings.writeTo(out);
        out.writeCollection(this.columns, Reference::toStream);
        out.writeVInt(this.items.size());
        for (Item items : this.items) {
            items.writeTo(out, this.columns);
        }
    }

    public List<Reference> columns() {
        return this.columns;
    }

    public SessionSettings sessionSettings() {
        return this.sessionSettings;
    }

    @Override
    protected long shallowSize() {
        return SHALLOW_SIZE;
    }

    public static class Item
    extends ShardRequest.Item
    implements IndexItem {
        private final List<String> pkValues;
        private final Object[] values;

        public Item(String id, Object[] values, List<String> pkValues, long seqNo, long primaryTerm, long version) {
            super(id);
            this.values = values;
            this.pkValues = pkValues;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
        }

        @Deprecated
        public static Item of(ShardUpsertRequest.Item item) {
            return new Item(item.id(), item.insertValues(), item.pkValues(), item.seqNo(), item.primaryTerm(), item.version());
        }

        public Item(StreamInput in, List<Reference> columns) throws IOException {
            super(in);
            int numValues = in.readVInt();
            this.values = new Object[numValues];
            for (int i = 0; i < numValues; ++i) {
                Streamer<?> streamer = columns.get(i).valueType().streamer();
                this.values[i] = streamer.readValueFrom(in);
            }
            this.pkValues = in.readStringList();
        }

        public void writeTo(StreamOutput out, List<Reference> columns) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                Streamer<?> streamer = columns.get(i).valueType().streamer();
                Object v = this.values[i];
                streamer.writeValueTo(out, v);
            }
            out.writeStringCollection(this.pkValues);
        }

        @Override
        public Object[] insertValues() {
            return this.values;
        }

        @Override
        public List<String> pkValues() {
            return this.pkValues;
        }

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        @Override
        public long version() {
            return this.version;
        }
    }
}

