/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.TranslogWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class XContentTranslogWriter
implements TranslogWriter {
    private final XContentBuilder builder;
    private final BytesStreamOutput output = new BytesStreamOutput();

    public XContentTranslogWriter() {
        try {
            this.builder = XContentFactory.json((OutputStream)this.output);
            this.builder.startObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void startArray() throws IOException {
        this.builder.startArray();
    }

    @Override
    public void endArray() throws IOException {
        this.builder.endArray();
    }

    @Override
    public void startObject() throws IOException {
        this.builder.startObject();
    }

    @Override
    public void endObject() throws IOException {
        this.builder.endObject();
    }

    @Override
    public void writeNull() throws IOException {
        this.builder.nullValue();
    }

    @Override
    public void writeFieldName(String fieldName) throws IOException {
        this.builder.field(fieldName);
    }

    @Override
    public void writeValue(Object value) throws IOException {
        this.builder.value(value);
    }

    @Override
    public void writeValue(String value) throws IOException {
        this.builder.value(value);
    }

    @Override
    public void writeValue(int value) throws IOException {
        this.builder.value(value);
    }

    @Override
    public void writeValue(long value) throws IOException {
        this.builder.value(value);
    }

    @Override
    public void writeValue(float value) throws IOException {
        this.builder.value(value);
    }

    @Override
    public void writeValue(double value) throws IOException {
        this.builder.value(value);
    }

    @Override
    public BytesReference bytes() throws IOException {
        this.builder.endObject();
        this.builder.close();
        return this.output.bytes();
    }
}

