/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.Streamer;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Routing;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CountPhase
implements UpstreamPhase {
    private static final Streamer<?>[] STREAMERS = new Streamer[]{DataTypes.LONG};
    private final int executionPhaseId;
    private final Routing routing;
    private final Symbol where;
    private DistributionInfo distributionInfo;
    private final boolean ignoreUnavailableIndex;

    public CountPhase(int executionPhaseId, Routing routing, Symbol where, DistributionInfo distributionInfo, boolean ignoreUnavailableIndex) {
        this.executionPhaseId = executionPhaseId;
        this.routing = routing;
        this.where = where;
        this.distributionInfo = distributionInfo;
        this.ignoreUnavailableIndex = ignoreUnavailableIndex;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.COUNT;
    }

    @Override
    public String name() {
        return "count";
    }

    @Override
    public Streamer<?>[] getStreamers() {
        return STREAMERS;
    }

    public Routing routing() {
        return this.routing;
    }

    public Symbol where() {
        return this.where;
    }

    @Override
    public int phaseId() {
        return this.executionPhaseId;
    }

    public Set<String> nodeIds() {
        return this.routing.nodes();
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    public boolean ignoreUnavailableIndex() {
        return this.ignoreUnavailableIndex;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitCountPhase(this, context);
    }

    public CountPhase(StreamInput in) throws IOException {
        this.executionPhaseId = in.readVInt();
        this.routing = new Routing(in);
        this.where = Symbol.fromStream(in);
        this.distributionInfo = new DistributionInfo(in);
        this.ignoreUnavailableIndex = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.executionPhaseId);
        this.routing.writeTo(out);
        Symbol.toStream(this.where, out);
        this.distributionInfo.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.ignoreUnavailableIndex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountPhase that = (CountPhase)o;
        return this.executionPhaseId == that.executionPhaseId && Objects.equals(this.routing, that.routing) && Objects.equals(this.where, that.where) && Objects.equals(this.distributionInfo, that.distributionInfo) && this.ignoreUnavailableIndex == that.ignoreUnavailableIndex;
    }

    public int hashCode() {
        return Objects.hash(this.executionPhaseId, this.routing, this.where, this.distributionInfo, this.ignoreUnavailableIndex);
    }
}

