/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.JoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.sql.tree.JoinType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class HashJoinPhase
extends JoinPhase {
    private final List<Symbol> leftJoinConditionInputs;
    private final List<Symbol> rightJoinConditionInputs;
    private final List<DataType<?>> leftOutputTypes;
    private final long estimatedRowSizeForLeft;

    public HashJoinPhase(UUID jobId, int executionNodeId, String name, List<Projection> projections, @Nullable MergePhase leftMergePhase, @Nullable MergePhase rightMergePhase, int numLeftOutputs, int numRightOutputs, Collection<String> executionNodes, @Nullable Symbol joinCondition, List<Symbol> leftJoinConditionInputs, List<Symbol> rightJoinConditionInputs, List<DataType<?>> leftOutputTypes, long estimatedRowSizeForLeft, JoinType joinType) {
        super(jobId, executionNodeId, name, projections, leftMergePhase, rightMergePhase, numLeftOutputs, numRightOutputs, executionNodes, joinType, joinCondition);
        assert (joinCondition != null) : "JoinCondition for HashJoin cannot be null";
        this.leftJoinConditionInputs = leftJoinConditionInputs;
        this.rightJoinConditionInputs = rightJoinConditionInputs;
        this.leftOutputTypes = leftOutputTypes;
        this.estimatedRowSizeForLeft = estimatedRowSizeForLeft;
    }

    public HashJoinPhase(StreamInput in) throws IOException {
        super(in);
        this.leftJoinConditionInputs = Symbols.fromStream(in);
        this.rightJoinConditionInputs = Symbols.fromStream(in);
        this.leftOutputTypes = DataTypes.listFromStream(in);
        this.estimatedRowSizeForLeft = in.readZLong();
        if (in.getVersion().before(Version.V_5_6_0)) {
            in.readZLong();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Symbols.toStream(this.leftJoinConditionInputs, out);
        Symbols.toStream(this.rightJoinConditionInputs, out);
        DataTypes.toStream(this.leftOutputTypes, out);
        out.writeZLong(this.estimatedRowSizeForLeft);
        if (out.getVersion().before(Version.V_5_6_0)) {
            out.writeZLong(-1L);
        }
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.HASH_JOIN;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitHashJoinPhase(this, context);
    }

    public List<Symbol> leftJoinConditionInputs() {
        return this.leftJoinConditionInputs;
    }

    public List<Symbol> rightJoinConditionInputs() {
        return this.rightJoinConditionInputs;
    }

    public List<DataType<?>> leftOutputTypes() {
        return this.leftOutputTypes;
    }

    public long estimatedRowSizeForLeft() {
        return this.estimatedRowSizeForLeft;
    }
}

