/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.JoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.sql.tree.JoinType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class NestedLoopPhase
extends JoinPhase {
    public final List<DataType<?>> leftSideColumnTypes;
    public final long estimatedRowsSizeLeft;
    public final long estimatedNumberOfRowsLeft;
    public final boolean blockNestedLoop;

    public NestedLoopPhase(UUID jobId, int executionNodeId, String name, List<Projection> projections, @Nullable MergePhase leftMergePhase, @Nullable MergePhase rightMergePhase, int numLeftOutputs, int numRightOutputs, Collection<String> executionNodes, JoinType joinType, @Nullable Symbol joinCondition, List<DataType<?>> leftSideColumnTypes, long estimatedRowsSizeLeft, long estimatedNumberOfRowsLeft, boolean blockNestedLoop) {
        super(jobId, executionNodeId, name, projections, leftMergePhase, rightMergePhase, numLeftOutputs, numRightOutputs, executionNodes, joinType, joinCondition);
        this.leftSideColumnTypes = leftSideColumnTypes;
        this.estimatedRowsSizeLeft = estimatedRowsSizeLeft;
        this.estimatedNumberOfRowsLeft = estimatedNumberOfRowsLeft;
        this.blockNestedLoop = blockNestedLoop;
    }

    public NestedLoopPhase(StreamInput in) throws IOException {
        super(in);
        this.leftSideColumnTypes = DataTypes.listFromStream(in);
        this.estimatedRowsSizeLeft = in.readZLong();
        this.estimatedNumberOfRowsLeft = in.readZLong();
        this.blockNestedLoop = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        DataTypes.toStream(this.leftSideColumnTypes, out);
        out.writeZLong(this.estimatedRowsSizeLeft);
        out.writeZLong(this.estimatedNumberOfRowsLeft);
        out.writeBoolean(this.blockNestedLoop);
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.NESTED_LOOP;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitNestedLoopPhase(this, context);
    }
}

