/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.NodeOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class NodeOperationGrouper {
    private NodeOperationGrouper() {
    }

    public static Map<String, Collection<NodeOperation>> groupByServer(Iterable<NodeOperation> nodeOperations) {
        HashMap<String, Collection<NodeOperation>> byServer = new HashMap<String, Collection<NodeOperation>>();
        for (NodeOperation nodeOperation : nodeOperations) {
            for (String server : nodeOperation.executionPhase().nodeIds()) {
                ArrayList<NodeOperation> values = (ArrayList<NodeOperation>)byServer.get(server);
                if (values == null) {
                    values = new ArrayList<NodeOperation>();
                }
                values.add(nodeOperation);
                byServer.put(server, values);
            }
        }
        return byServer;
    }
}

