/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.analyze.OrderBy;
import io.crate.data.Paging;
import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Routing;
import io.crate.metadata.RowGranularity;
import io.crate.planner.distribution.DistributionInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class RoutedCollectPhase
extends AbstractProjectionsPhase
implements CollectPhase {
    private final Routing routing;
    private final List<Symbol> toCollect;
    private final RowGranularity maxRowGranularity;
    private final Symbol where;
    private final boolean ignoreUnavailableIndex;
    private DistributionInfo distributionInfo;
    @Nullable
    private Integer nodePageSizeHint = null;
    @Nullable
    private OrderBy orderBy = null;

    public RoutedCollectPhase(UUID jobId, int executionNodeId, String name, Routing routing, RowGranularity maxRowGranularity, boolean ignoreUnavailableIndex, List<Symbol> toCollect, Collection<? extends Projection> projections, Symbol where, DistributionInfo distributionInfo) {
        super(jobId, executionNodeId, name, projections);
        assert (toCollect.stream().noneMatch(st -> st.any(s -> s instanceof ScopedSymbol || s instanceof SelectSymbol))) : "toCollect must not contain any fields or selectSymbols: " + String.valueOf(toCollect);
        assert (!where.any(s -> s instanceof ScopedSymbol || s instanceof SelectSymbol)) : "whereClause must not contain any fields or selectSymbols: " + String.valueOf(where);
        assert (routing != null) : "routing must not be null";
        this.where = where;
        this.routing = routing;
        this.maxRowGranularity = maxRowGranularity;
        this.toCollect = toCollect;
        this.distributionInfo = distributionInfo;
        this.ignoreUnavailableIndex = ignoreUnavailableIndex;
        this.outputTypes = RoutedCollectPhase.extractOutputTypes(toCollect, this.projections);
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.COLLECT;
    }

    public Set<String> nodeIds() {
        return this.routing.nodes();
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    @Nullable
    public Integer nodePageSizeHint() {
        return this.nodePageSizeHint;
    }

    public void nodePageSizeHint(Integer nodePageSizeHint) {
        this.nodePageSizeHint = nodePageSizeHint;
    }

    public void pageSizeHint(Integer pageSize) {
        this.nodePageSizeHint(Paging.getWeightedPageSize((Integer)pageSize, (double)(1.0 / (double)Math.max(1, this.nodeIds().size()))));
    }

    public int shardQueueSize(String nodeId) {
        return Paging.getWeightedPageSize((Integer)this.nodePageSizeHint, (double)(1.0 / (double)Math.max(1, this.routing.numShards(nodeId))));
    }

    @Nullable
    public OrderBy orderBy() {
        return this.orderBy;
    }

    public void orderBy(@Nullable OrderBy orderBy) {
        assert (orderBy == null || orderBy.orderBySymbols().stream().noneMatch(st -> st.any(s -> s instanceof ScopedSymbol))) : "orderBy must not contain any fields: " + String.valueOf(orderBy.orderBySymbols());
        this.orderBy = orderBy;
    }

    public Symbol where() {
        return this.where;
    }

    public Routing routing() {
        return this.routing;
    }

    @Override
    public List<Symbol> toCollect() {
        return this.toCollect;
    }

    public boolean isRouted() {
        return this.routing != null && this.routing.hasLocations();
    }

    public RowGranularity maxRowGranularity() {
        return this.maxRowGranularity;
    }

    public boolean ignoreUnavailableIndex() {
        return this.ignoreUnavailableIndex;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitRoutedCollectPhase(this, context);
    }

    public RoutedCollectPhase(StreamInput in) throws IOException {
        super(in);
        this.distributionInfo = new DistributionInfo(in);
        this.toCollect = Symbols.fromStream(in);
        this.maxRowGranularity = RowGranularity.fromStream(in);
        this.routing = new Routing(in);
        this.where = Symbol.fromStream(in);
        this.nodePageSizeHint = in.readOptionalVInt();
        this.orderBy = in.readOptionalWriteable(OrderBy::new);
        this.ignoreUnavailableIndex = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.distributionInfo.writeTo(out);
        Symbols.toStream(this.toCollect, out);
        RowGranularity.toStream(this.maxRowGranularity, out);
        this.routing.writeTo(out);
        Symbol.toStream(this.where, out);
        out.writeOptionalVInt(this.nodePageSizeHint);
        out.writeOptionalWriteable(this.orderBy);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.ignoreUnavailableIndex);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoutedCollectPhase that = (RoutedCollectPhase)o;
        return Objects.equals(this.routing, that.routing) && Objects.equals(this.toCollect, that.toCollect) && this.maxRowGranularity == that.maxRowGranularity && Objects.equals(this.where, that.where) && Objects.equals(this.ignoreUnavailableIndex, that.ignoreUnavailableIndex) && Objects.equals(this.distributionInfo, that.distributionInfo) && Objects.equals(this.nodePageSizeHint, that.nodePageSizeHint) && Objects.equals(this.orderBy, that.orderBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.routing, this.toCollect, this.maxRowGranularity, this.where, this.ignoreUnavailableIndex, this.distributionInfo, this.nodePageSizeHint, this.orderBy});
    }
}

