/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RowGranularity;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class DMLProjection
extends Projection {
    private static final List<Symbol> OUTPUTS = List.of(new InputColumn(0, DataTypes.LONG));
    final Symbol uidSymbol;

    DMLProjection(Symbol uidSymbol) {
        this.uidSymbol = uidSymbol;
    }

    DMLProjection(StreamInput in) throws IOException {
        this.uidSymbol = Symbol.fromStream(in);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return OUTPUTS;
    }

    public Symbol uidSymbol() {
        return this.uidSymbol;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DMLProjection that = (DMLProjection)o;
        return Objects.equals(this.uidSymbol, that.uidSymbol);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uidSymbol);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbol.toStream(this.uidSymbol, out);
    }

    @Override
    public RowGranularity requiredGranularity() {
        return RowGranularity.SHARD;
    }
}

