/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.AggregationProjection;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.DeleteProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.FilterProjection;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.LimitAndOffsetProjection;
import io.crate.execution.dsl.projection.LimitDistinctProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.OrderedLimitAndOffsetProjection;
import io.crate.execution.dsl.projection.ProjectSetProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.SourceIndexWriterProjection;
import io.crate.execution.dsl.projection.SourceIndexWriterReturnSummaryProjection;
import io.crate.execution.dsl.projection.SysUpdateProjection;
import io.crate.execution.dsl.projection.UpdateProjection;
import io.crate.execution.dsl.projection.WindowAggProjection;
import io.crate.execution.dsl.projection.WriterProjection;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;

public enum ProjectionType {
    LIMITANDOFFSET(LimitAndOffsetProjection::new),
    GROUP(GroupProjection::new),
    AGGREGATION(AggregationProjection::new),
    MERGE_COUNT_AGGREGATION(i -> MergeCountProjection.INSTANCE),
    FILTER(FilterProjection::new),
    WRITER(WriterProjection::new),
    INDEX_WRITER(SourceIndexWriterProjection::new),
    INDEX_WRITER_RETURN_SUMMARY(SourceIndexWriterReturnSummaryProjection::new),
    COLUMN_INDEX_WRITER(ColumnIndexWriterProjection::new),
    UPDATE(UpdateProjection::new),
    SYS_UPDATE(SysUpdateProjection::new),
    DELETE(DeleteProjection::new),
    FETCH(null),
    LIMITANDOFFSET_ORDERED(OrderedLimitAndOffsetProjection::new),
    EVAL(EvalProjection::new),
    PROJECT_SET(ProjectSetProjection::new),
    WINDOW_AGGREGATION(WindowAggProjection::new),
    LIMIT_DISTINCT(LimitDistinctProjection::new),
    CORRELATED_JOIN(in -> {
        throw new UnsupportedOperationException("Cannot stream correlated join projection");
    });

    private final Projection.ProjectionFactory<?> factory;

    private ProjectionType(Projection.ProjectionFactory<?> factory) {
        this.factory = factory;
    }

    public Projection newInstance(StreamInput in) throws IOException {
        return this.factory.newInstance(in);
    }
}

