/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.concurrent.CountdownFuture;

class InitializationTracker {
    final CountdownFuture future;

    InitializationTracker(int numServer) {
        assert (numServer > 0) : "Must have at least one server";
        this.future = new CountdownFuture(numServer);
    }

    void jobInitialized() {
        this.future.onSuccess();
    }

    void jobInitializationFailed(Throwable t) {
        this.future.onFailure(prevFailure -> {
            if (prevFailure == null || prevFailure instanceof InterruptedException) {
                return t;
            }
            return prevFailure;
        });
    }

    public String toString() {
        return "InitializationTracker{" + String.valueOf(this.future) + "}";
    }
}

