/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.common.collections.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PrimitiveMapWithNulls<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;
    private V nullKeyValue = null;

    public PrimitiveMapWithNulls(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size() + (this.nullKeyValue == null ? 0 : 1);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty() && this.nullKeyValue == null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.nullKeyValue != null;
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value) || value.equals(this.nullKeyValue);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.nullKeyValue;
        }
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            V v = this.nullKeyValue;
            this.nullKeyValue = value;
            return v;
        }
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            V v = this.nullKeyValue;
            this.nullKeyValue = null;
            return v;
        }
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("putAll is not supported on PrimitiveMapWithNulls");
    }

    @Override
    public void clear() {
        this.nullKeyValue = null;
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        if (this.nullKeyValue == null) {
            return this.delegate.keySet();
        }
        HashSet<K> ks = new HashSet<K>(this.delegate.keySet());
        ks.add(null);
        return ks;
    }

    @Override
    public Collection<V> values() {
        if (this.nullKeyValue == null) {
            return this.delegate.values();
        }
        return Lists.concat(this.delegate.values(), this.nullKeyValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.nullKeyValue == null) {
            return this.delegate.entrySet();
        }
        final Set<Map.Entry<K, V>> entries = this.delegate.entrySet();
        return new Set<Map.Entry<K, V>>(this){
            final /* synthetic */ PrimitiveMapWithNulls this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int size() {
                return entries.size() + 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = entries.iterator();
                return new Iterator<Map.Entry<K, V>>(this){
                    boolean visitedNullKey = false;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.visitedNullKey) {
                            return true;
                        }
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.visitedNullKey) {
                            this.visitedNullKey = true;
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return null;
                                }

                                @Override
                                public V getValue() {
                                    return this$1.this$0.nullKeyValue;
                                }

                                @Override
                                public V setValue(V value) {
                                    Object v = this$1.this$0.nullKeyValue;
                                    this$1.this$0.nullKeyValue = value;
                                    return v;
                                }
                            };
                        }
                        return (Map.Entry)it.next();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException("");
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("");
            }
        };
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key == null) {
            return this.nullKeyValue == null ? defaultValue : this.nullKeyValue;
        }
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        action.accept(null, this.nullKeyValue);
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.nullKeyValue = function.apply(null, this.nullKeyValue);
        this.delegate.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("putIfAbsent not implemented");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("remove not implemented");
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException("replace not implemented");
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException("replace not implemented");
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException("computeIfAbsent not implemented");
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException("computeIfPresent not implemented");
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException("compute not implemented");
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException("merge not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveMapWithNulls that = (PrimitiveMapWithNulls)o;
        if (!this.delegate.equals(that.delegate)) {
            return false;
        }
        return Objects.equals(this.nullKeyValue, that.nullKeyValue);
    }

    @Override
    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + (this.nullKeyValue != null ? this.nullKeyValue.hashCode() : 0);
        return result;
    }
}

