/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.common.collections.Lists;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.impl.StandardDeviationAggregation;
import io.crate.execution.engine.aggregation.statistics.StandardDeviationSamp;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.jetbrains.annotations.Nullable;

public class StandardDeviationSampAggregation
extends StandardDeviationAggregation<StandardDeviationSamp> {
    public static final List<String> NAMES = List.of("stddev_samp", "stddev");
    private static final List<DataType<?>> SUPPORTED_TYPES;

    public static void register(Functions.Builder builder) {
        for (String name : NAMES) {
            for (DataType<?> supportedType : SUPPORTED_TYPES) {
                builder.add(Signature.builder(name, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), StandardDeviationSampAggregation::new);
            }
        }
    }

    public StandardDeviationSampAggregation(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public DataType<?> partialType() {
        return new StdDevSampStateType();
    }

    @Override
    @Nullable
    public StandardDeviationSamp newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)StandardDeviationSamp.fixedSize());
        return new StandardDeviationSamp();
    }

    static {
        DataTypes.register(8193, streamInput -> StdDevSampStateType.INSTANCE);
        SUPPORTED_TYPES = Lists.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, (Object)DataTypes.TIMESTAMPZ);
    }

    public static class StdDevSampStateType
    extends StandardDeviationAggregation.StdDevStateType<StandardDeviationSamp> {
        public static final StdDevSampStateType INSTANCE = new StdDevSampStateType();
        public static final int ID = 8193;

        @Override
        public int id() {
            return 8193;
        }

        @Override
        public String getName() {
            return "stddev_sampl_state";
        }

        @Override
        public StandardDeviationSamp readValueFrom(StreamInput in) throws IOException {
            return new StandardDeviationSamp(in);
        }
    }
}

