/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.MergingDigest;
import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class TDigestState
extends MergingDigest {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TDigestState.class);
    public static final double DEFAULT_COMPRESSION = 200.0;
    private double[] fractions;
    private int lastByteSize = 0;

    TDigestState(double compression, double[] fractions) {
        super(compression);
        this.fractions = fractions;
    }

    static TDigestState createEmptyState() {
        return new TDigestState(200.0, new double[0]);
    }

    boolean isEmpty() {
        return this.fractions.length == 0;
    }

    double[] fractions() {
        return this.fractions;
    }

    void fractions(double[] fractions) {
        this.fractions = fractions;
    }

    int addGetSizeDelta(double value) {
        this.add(value);
        int newByteSize = this.byteSize();
        int delta = newByteSize - this.lastByteSize;
        this.lastByteSize = newByteSize;
        return delta;
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        out.writeDouble(state.compression());
        out.writeDoubleArray(state.fractions);
        out.writeVInt(state.centroidCount());
        for (Centroid centroid : state.centroids()) {
            out.writeDouble(centroid.mean());
            out.writeVLong(centroid.count());
        }
    }

    public static TDigestState read(StreamInput in) throws IOException {
        double compression = in.readDouble();
        double[] fractions = in.readDoubleArray();
        TDigestState state = new TDigestState(compression, fractions);
        int n = in.readVInt();
        for (int i = 0; i < n; ++i) {
            state.add(in.readDouble(), in.readVInt());
        }
        return state;
    }
}

