/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.execution.engine.aggregation.statistics.Variance;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class VarianceAggregation
extends AggregationFunction<Variance, Double> {
    public static final String NAME = "variance";
    static final List<DataType<?>> SUPPORTED_TYPES;
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        for (DataType<?> supportedType : SUPPORTED_TYPES) {
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), VarianceAggregation::new);
        }
    }

    public VarianceAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    @Nullable
    public Variance newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)VarianceStateType.INSTANCE.fixedSize());
        return new Variance();
    }

    @Override
    public Variance iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Variance state, Input<?> ... args) throws CircuitBreakingException {
        Number value;
        if (state != null && (value = (Number)args[0].value()) != null) {
            state.increment(value.doubleValue());
        }
        return state;
    }

    @Override
    public Variance reduce(RamAccounting ramAccounting, Variance state1, Variance state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        state1.merge(state2);
        return state1;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public Variance removeFromAggregatedState(RamAccounting ramAccounting, Variance previousAggState, Input<?>[] stateToRemove) {
        Number value;
        if (previousAggState != null && (value = (Number)stateToRemove[0].value()) != null) {
            previousAggState.decrement(value.doubleValue());
        }
        return previousAggState;
    }

    @Override
    public Double terminatePartial(RamAccounting ramAccounting, Variance state) {
        double result = state.result();
        return Double.isNaN(result) ? null : Double.valueOf(result);
    }

    @Override
    public DataType<?> partialType() {
        return VarianceStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        switch (reference.valueType().id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return new SortedNumericDocValueAggregator<Variance>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                    ramAccounting.addBytes((long)VarianceStateType.INSTANCE.fixedSize());
                    return new Variance();
                }, (ramAccounting, values, state) -> state.increment(values.nextValue()));
            }
            case 7: {
                return new SortedNumericDocValueAggregator<Variance>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                    ramAccounting.addBytes((long)VarianceStateType.INSTANCE.fixedSize());
                    return new Variance();
                }, (ramAccounting, values, state) -> {
                    float value = NumericUtils.sortableIntToFloat((int)((int)values.nextValue()));
                    state.increment(value);
                });
            }
            case 6: {
                return new SortedNumericDocValueAggregator<Variance>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                    ramAccounting.addBytes((long)VarianceStateType.INSTANCE.fixedSize());
                    return new Variance();
                }, (ramAccounting, values, state) -> {
                    double value = NumericUtils.sortableLongToDouble((long)values.nextValue());
                    state.increment(value);
                });
            }
        }
        return null;
    }

    static {
        DataTypes.register(2048, streamInput -> VarianceStateType.INSTANCE);
        SUPPORTED_TYPES = Lists.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, (Object)DataTypes.TIMESTAMPZ);
    }

    public static class VarianceStateType
    extends DataType<Variance>
    implements Streamer<Variance>,
    FixedWidthType {
        public static final VarianceStateType INSTANCE = new VarianceStateType();
        public static final int ID = 2048;

        @Override
        public int id() {
            return 2048;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "variance_state";
        }

        @Override
        public Streamer<Variance> streamer() {
            return this;
        }

        @Override
        public Variance sanitizeValue(Object value) {
            return (Variance)value;
        }

        @Override
        public int compare(Variance val1, Variance val2) {
            return val1.compareTo(val2);
        }

        @Override
        public Variance readValueFrom(StreamInput in) throws IOException {
            return new Variance(in);
        }

        @Override
        public void writeValueTo(StreamOutput out, Variance v) throws IOException {
            v.writeTo(out);
        }

        @Override
        public int fixedSize() {
            return 56;
        }

        @Override
        public long valueBytes(Variance value) {
            return this.fixedSize();
        }
    }
}

