/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.templates;

import io.crate.common.CheckedTriConsumer;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.memory.MemoryManager;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.Version;
import org.elasticsearch.common.TriFunction;
import org.jetbrains.annotations.Nullable;

public class BinaryDocValueAggregator<T>
implements DocValueAggregator<T> {
    private final String columnName;
    private final TriFunction<RamAccounting, MemoryManager, Version, T> stateInitializer;
    private final CheckedTriConsumer<RamAccounting, SortedSetDocValues, T, IOException> docValuesConsumer;
    protected SortedSetDocValues values;

    public BinaryDocValueAggregator(String columnName, TriFunction<RamAccounting, MemoryManager, Version, T> stateInitializer, CheckedTriConsumer<RamAccounting, SortedSetDocValues, T, IOException> docValuesConsumer) {
        this.columnName = columnName;
        this.stateInitializer = stateInitializer;
        this.docValuesConsumer = docValuesConsumer;
    }

    @Override
    public T initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
        return this.stateInitializer.apply(ramAccounting, memoryManager, minNodeVersion);
    }

    @Override
    public void loadDocValues(LeafReaderContext reader) throws IOException {
        this.values = DocValues.getSortedSet((LeafReader)reader.reader(), (String)this.columnName);
    }

    @Override
    public void apply(RamAccounting ramAccounting, int doc, T state) throws IOException {
        if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
            this.docValuesConsumer.accept((Object)ramAccounting, (Object)this.values, state);
        }
    }

    @Override
    @Nullable
    public Object partialResult(RamAccounting ramAccounting, T state) {
        return state;
    }
}

