/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.statistics;

import io.crate.types.NumericType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class NumericVariance
implements Writeable,
Comparable<NumericVariance> {
    private BigDecimal sumOfSqrs;
    private BigDecimal sum;
    private long count;

    public NumericVariance() {
        this.sumOfSqrs = new BigDecimal(0);
        this.sum = new BigDecimal(0);
        this.count = 0L;
    }

    public NumericVariance(StreamInput in) throws IOException {
        this.sumOfSqrs = NumericType.INSTANCE.readValueFrom(in);
        this.sum = NumericType.INSTANCE.readValueFrom(in);
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        NumericType.INSTANCE.writeValueTo(out, this.sumOfSqrs);
        NumericType.INSTANCE.writeValueTo(out, this.sum);
        out.writeVLong(this.count);
    }

    protected long count() {
        return this.count;
    }

    public void increment(BigDecimal value) {
        this.sumOfSqrs = this.sumOfSqrs.add(value.multiply(value));
        this.sum = this.sum.add(value);
        ++this.count;
    }

    public void decrement(BigDecimal value) {
        this.sumOfSqrs = this.sumOfSqrs.subtract(value.multiply(value));
        this.sum = this.sum.subtract(value);
        --this.count;
    }

    public BigDecimal result() {
        if (this.count == 0L) {
            return null;
        }
        return this.sumOfSqrs.subtract(this.sum.multiply(this.sum).divide(BigDecimal.valueOf(this.count), MathContext.DECIMAL128)).divide(BigDecimal.valueOf(this.count), MathContext.DECIMAL128);
    }

    public void merge(NumericVariance other) {
        this.sumOfSqrs = this.sumOfSqrs.add(other.sumOfSqrs);
        this.sum = this.sum.add(other.sum);
        this.count += other.count;
    }

    public long size() {
        return NumericType.size(this.sum) + NumericType.size(this.sumOfSqrs) + 64L;
    }

    @Override
    public int compareTo(NumericVariance o) {
        return this.result().compareTo(o.result());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericVariance variance = (NumericVariance)o;
        return Objects.equals(variance.result(), this.result());
    }

    public int hashCode() {
        return Objects.hash(this.result());
    }
}

