/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.common.annotations.GuardedBy;
import io.crate.common.collections.RefCountedItem;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.MapSideDataCollectOperation;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.Task;
import io.crate.memory.MemoryManager;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.Version;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.concurrent.PriorityRunnable;
import org.jetbrains.annotations.VisibleForTesting;

public class CollectTask
implements Task {
    private final CollectPhase collectPhase;
    private final TransactionContext txnCtx;
    private final MapSideDataCollectOperation collectOperation;
    private final RamAccounting ramAccounting;
    private final Function<RamAccounting, MemoryManager> memoryManagerFactory;
    private final SharedShardContexts sharedShardContexts;
    private final IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> searchers = new IntObjectHashMap();
    private final RowConsumer consumer;
    private final int ramAccountingBlockSizeInBytes;
    @GuardedBy(value="searchers")
    private final ArrayList<MemoryManager> memoryManagers = new ArrayList();
    private final Version minNodeVersion;
    private final CompletableFuture<Void> consumerCompleted;
    private final CompletableFuture<BatchIterator<Row>> batchIterator = new CompletableFuture();
    private final AtomicBoolean started = new AtomicBoolean(false);
    @GuardedBy(value="searchers")
    private boolean releasedResources = false;
    private long totalBytes = -1L;
    private volatile Throwable killed;

    public CollectTask(CollectPhase collectPhase, TransactionContext txnCtx, MapSideDataCollectOperation collectOperation, RamAccounting ramAccounting, Function<RamAccounting, MemoryManager> memoryManagerFactory, RowConsumer consumer, SharedShardContexts sharedShardContexts, Version minNodeVersion, int ramAccountingBlockSizeInBytes) {
        this.collectPhase = collectPhase;
        this.txnCtx = txnCtx;
        this.collectOperation = collectOperation;
        this.ramAccounting = ramAccounting;
        this.memoryManagerFactory = memoryManagerFactory;
        this.sharedShardContexts = sharedShardContexts;
        this.consumer = consumer;
        this.ramAccountingBlockSizeInBytes = ramAccountingBlockSizeInBytes;
        this.minNodeVersion = minNodeVersion;
        this.batchIterator.whenComplete((it, err) -> {
            if (err == null) {
                try {
                    String threadPoolName = CollectTask.threadPoolName(collectPhase, it.hasLazyResultSet());
                    Priority priority = CollectTask.getPriority(collectPhase);
                    PrioritizedRunnable runnable = PriorityRunnable.of(priority, collectPhase.name(), () -> consumer.accept(it, null));
                    collectOperation.launch(runnable, threadPoolName);
                }
                catch (Throwable t) {
                    consumer.accept(null, t);
                }
            } else {
                consumer.accept(null, err);
            }
        });
        this.consumerCompleted = consumer.completionFuture().handle((res, err) -> {
            this.totalBytes = ramAccounting.totalBytes();
            this.releaseResources();
            if (err != null) {
                Exceptions.rethrowUnchecked((Throwable)err);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResources() {
        IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> intObjectHashMap = this.searchers;
        synchronized (intObjectHashMap) {
            if (!this.releasedResources) {
                this.releasedResources = true;
                for (ObjectCursor cursor : this.searchers.values()) {
                    ((RefCountedItem)cursor.value).close();
                }
                this.searchers.clear();
                for (MemoryManager memoryManager : this.memoryManagers) {
                    memoryManager.close();
                }
            } else {
                throw new AssertionError((Object)"Double release must not happen");
            }
            this.memoryManagers.clear();
        }
    }

    @Override
    public CompletableFuture<Void> completionFuture() {
        return this.consumerCompleted;
    }

    public void kill(Throwable throwable) {
        this.killed = throwable;
        if (this.started.compareAndSet(false, true)) {
            this.consumer.accept(null, throwable);
        } else {
            this.batchIterator.whenComplete((it, throwable2) -> {
                this.consumer.kill(throwable);
                if (it != null) {
                    it.kill(throwable);
                }
            });
        }
    }

    public void raiseIfKilled() {
        Throwable t = this.killed;
        if (t != null) {
            throw Exceptions.toRuntimeException((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<Void> start() {
        if (this.started.compareAndSet(false, true)) {
            try {
                CompletableFuture<BatchIterator<Row>> futureIt = this.collectOperation.createIterator(this.txnCtx, this.collectPhase, this.consumer.requiresScroll(), this);
                futureIt.whenComplete((it, err) -> {
                    if (err == null) {
                        this.batchIterator.complete((BatchIterator<Row>)it);
                    } else {
                        this.batchIterator.completeExceptionally((Throwable)err);
                    }
                });
            }
            catch (Throwable t) {
                this.batchIterator.completeExceptionally(t);
            }
        }
        return null;
    }

    @Override
    public int id() {
        return this.collectPhase.phaseId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSearcher(int searcherId, RefCountedItem<? extends IndexSearcher> searcher) {
        IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> intObjectHashMap = this.searchers;
        synchronized (intObjectHashMap) {
            if (!this.releasedResources) {
                RefCountedItem replacedSearcher = (RefCountedItem)this.searchers.put(searcherId, searcher);
                if (replacedSearcher != null) {
                    replacedSearcher.close();
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "ShardCollectContext for %d already added", searcherId));
                }
            } else {
                searcher.close();
                try {
                    this.consumerCompleted.join();
                }
                catch (CompletionException e) {
                    throw Exceptions.toRuntimeException((Throwable)e.getCause());
                }
                throw new AssertionError((Object)"addSearcher call after resources have already been released once");
            }
        }
    }

    @Override
    public long bytesUsed() {
        if (this.totalBytes == -1L) {
            return this.ramAccounting.totalBytes();
        }
        return this.totalBytes;
    }

    @Override
    public String name() {
        return this.collectPhase.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> intObjectHashMap = this.searchers;
        synchronized (intObjectHashMap) {
            String iterator = this.batchIterator.isDone() && !this.batchIterator.isCompletedExceptionally() ? this.batchIterator.join().toString() : this.batchIterator.toString();
            return "CollectTask{id=" + this.collectPhase.phaseId() + ", sharedContexts=" + String.valueOf(this.sharedShardContexts) + ", consumer=" + String.valueOf(this.consumer) + ", searchContexts=" + String.valueOf(this.searchers.keys()) + ", batchIterator=" + iterator + ", finished=" + this.consumerCompleted.isDone() + "}";
        }
    }

    public TransactionContext txnCtx() {
        return this.txnCtx;
    }

    public RamAccounting getRamAccounting() {
        return new BlockBasedRamAccounting(arg_0 -> ((RamAccounting)this.ramAccounting).addBytes(arg_0), this.ramAccountingBlockSizeInBytes);
    }

    public SharedShardContexts sharedShardContexts() {
        return this.sharedShardContexts;
    }

    @VisibleForTesting
    static Priority getPriority(CollectPhase phase) {
        RoutedCollectPhase routedPhase;
        if (phase instanceof RoutedCollectPhase && (routedPhase = (RoutedCollectPhase)phase).maxRowGranularity().ordinal() < RowGranularity.DOC.ordinal()) {
            return Priority.URGENT;
        }
        return Priority.LOW;
    }

    @VisibleForTesting
    static String threadPoolName(CollectPhase phase, boolean involvedIO) {
        return involvedIO ? "search" : "same";
    }

    public MemoryManager memoryManager() {
        MemoryManager memoryManager = this.memoryManagerFactory.apply(this.ramAccounting);
        IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> intObjectHashMap = this.searchers;
        synchronized (intObjectHashMap) {
            if (!this.releasedResources) {
                this.memoryManagers.add(memoryManager);
                return memoryManager;
            }
            memoryManager.close();
            try {
                this.consumerCompleted.join();
            }
            catch (CompletionException e) {
                throw Exceptions.toRuntimeException((Throwable)e.getCause());
            }
            throw new AssertionError((Object)"memoryManager access after resources have already been released once");
        }
    }

    public Version minNodeVersion() {
        return this.minNodeVersion;
    }
}

