/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.NestableInput;
import java.util.function.Function;

public interface NestableCollectExpression<T, R>
extends CollectExpression<T, R>,
NestableInput<R> {
    public static <T, R> NestableCollectExpression<T, R> constant(R val) {
        return new ConstantNestableCollectExpression(val);
    }

    public static <T, R> NestableCollectExpression<T, R> forFunction(Function<T, R> fun) {
        return new FuncExpression<T, R>(fun);
    }

    public static class ConstantNestableCollectExpression<T, R>
    implements NestableCollectExpression<T, R> {
        private final R val;

        ConstantNestableCollectExpression(R val) {
            this.val = val;
        }

        @Override
        public void setNextRow(T tRow) {
        }

        public R value() {
            return this.val;
        }
    }

    public static class FuncExpression<T, R>
    implements NestableCollectExpression<T, R> {
        private final Function<T, R> f;
        private R value;

        FuncExpression(Function<T, R> f) {
            this.f = f;
        }

        @Override
        public void setNextRow(T tRow) {
            this.value = this.f.apply(tRow);
        }

        public R value() {
            return this.value;
        }

        public String toString() {
            return "FuncExpression{func=" + String.valueOf(this.f) + "}";
        }
    }
}

