/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.analyze.Id;
import io.crate.common.annotations.NotThreadSafe;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class RowShardResolver {
    private final Function<List<String>, String> idFunction;
    private final List<Input<?>> primaryKeyInputs;
    private final Input<?> routingInput;
    private final Iterable<CollectExpression<Row, ?>> expressions;
    private String id;
    private String routing;
    private List<String> pkValues;
    private long autoGeneratedTimestamp = -1L;
    private boolean setAutoGeneratedTimestamp;

    public RowShardResolver(TransactionContext txnCtx, NodeContext nodeCtx, List<ColumnIdent> pkColumns, List<? extends Symbol> primaryKeySymbols, @Nullable ColumnIdent clusteredByColumn, @Nullable Symbol routingSymbol) {
        InputFactory inputFactory = new InputFactory(nodeCtx);
        InputFactory.Context<CollectExpression<Row, ?>> context = inputFactory.ctxForInputColumns(txnCtx);
        this.idFunction = Id.compileWithNullValidation(pkColumns, clusteredByColumn);
        this.setAutoGeneratedTimestamp = pkColumns.isEmpty() || pkColumns.size() == 1 && pkColumns.get(0).equals(SysColumns.ID.COLUMN);
        this.routingInput = routingSymbol == null ? null : context.add(routingSymbol);
        this.primaryKeyInputs = new ArrayList(primaryKeySymbols.size());
        for (Symbol symbol : primaryKeySymbols) {
            this.primaryKeyInputs.add(context.add(symbol));
        }
        this.expressions = context.expressions();
    }

    public void setNextRow(Row row) {
        for (CollectExpression<Row, ?> expression : this.expressions) {
            expression.setNextRow(row);
        }
        if (this.setAutoGeneratedTimestamp) {
            this.autoGeneratedTimestamp = Math.max(0L, System.currentTimeMillis());
        }
        this.pkValues = RowShardResolver.pkValues(this.primaryKeyInputs);
        this.id = this.idFunction.apply(this.pkValues);
        if (this.routingInput == null) {
            this.routing = null;
        } else {
            Object clusteredBy = this.routingInput.value();
            if (clusteredBy == null) {
                throw new IllegalArgumentException("Clustered by value must not be NULL");
            }
            this.routing = clusteredBy.toString();
        }
    }

    private static List<String> pkValues(List<Input<?>> primaryKeyInputs) {
        return Lists.map(primaryKeyInputs, input -> DataTypes.STRING.implicitCast(input.value()));
    }

    public long autoGeneratedTimestamp() {
        return this.autoGeneratedTimestamp;
    }

    public List<String> pkValues() {
        return this.pkValues;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }
}

