/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.common.collections.Lists;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.collect.collectors.DummyScorer;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.collect.collectors.ScoreDocRowFunction;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.lucene.WrappingCollectorManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.lucene.MinimumScoreCollector;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuceneOrderedDocCollector
extends OrderedDocCollector {
    private static final Logger LOGGER = LogManager.getLogger(LuceneOrderedDocCollector.class);
    private static final int OPTIMIZE_BATCH_SIZE_THRESHOLD = 1000;
    private static final long FIELD_DOC_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldDoc.class);
    private final Query query;
    private final Float minScore;
    private final boolean doDocsScores;
    private final RamAccounting ramAccounting;
    private final CollectorContext collectorContext;
    private final Function<FieldDoc, Query> searchAfterQueryOptimize;
    private final Sort sort;
    private final Collection<? extends LuceneCollectorExpression<?>> expressions;
    private final ScoreDocRowFunction rowFunction;
    private final DummyScorer scorer;
    private final IndexSearcher searcher;
    private final AtomicReference<Throwable> killed = new AtomicReference();
    private int batchSize;
    private boolean batchSizeReduced = false;
    @Nullable
    private FieldDoc lastDoc = null;

    public LuceneOrderedDocCollector(ShardId shardId, IndexSearcher searcher, Query query, Float minScore, boolean doDocsScores, int batchSize, RamAccounting ramAccounting, CollectorContext collectorContext, Function<FieldDoc, Query> searchAfterQueryOptimize, Sort sort, List<? extends Input<?>> inputs, Collection<? extends LuceneCollectorExpression<?>> expressions) {
        super(shardId);
        this.searcher = searcher;
        this.query = query;
        this.minScore = minScore;
        this.doDocsScores = doDocsScores;
        this.ramAccounting = ramAccounting;
        this.batchSize = Math.min(batchSize, searcher.getIndexReader().numDocs() + 1);
        this.collectorContext = collectorContext;
        this.searchAfterQueryOptimize = searchAfterQueryOptimize;
        this.sort = sort;
        this.scorer = new DummyScorer();
        this.expressions = expressions;
        this.rowFunction = new ScoreDocRowFunction(searcher.getIndexReader(), inputs, expressions, this.scorer, this::raiseIfKilled);
    }

    @Override
    public KeyIterable<ShardId, Row> collect() {
        try {
            if (this.lastDoc == null) {
                return this.initialSearch();
            }
            return this.searchMore();
        }
        catch (Exception e) {
            Exceptions.rethrowUnchecked((Throwable)e);
            return null;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void kill(@NotNull Throwable t) {
        this.killed.set(t);
    }

    private KeyIterable<ShardId, Row> initialSearch() throws IOException {
        if (this.batchSize > 1000 && !this.batchSizeReduced) {
            this.batchSizeReduced = true;
            this.batchSize = Math.min(this.batchSize, this.searcher.count(this.query) + 1);
        }
        for (LuceneCollectorExpression<?> expression : this.expressions) {
            expression.startCollect(this.collectorContext);
            expression.setScorer(this.scorer);
        }
        this.ramAccounting.addBytes((long)this.batchSize * FIELD_DOC_SIZE);
        TopFieldCollectorManager topFieldCollectorManager = new TopFieldCollectorManager(this.sort, this.batchSize, null, 0, false);
        return this.doSearch(topFieldCollectorManager, this.minScore, this.query);
    }

    private KeyIterable<ShardId, Row> searchMore() throws IOException {
        if (this.exhausted()) {
            LOGGER.trace("searchMore but EXHAUSTED");
            return this.empty();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("searchMore from [{}]", (Object)this.lastDoc);
        }
        this.ramAccounting.addBytes((long)this.batchSize * FIELD_DOC_SIZE);
        TopFieldCollectorManager topFieldCollectorManager = new TopFieldCollectorManager(this.sort, this.batchSize, this.lastDoc, 0, false);
        return this.doSearch(topFieldCollectorManager, this.minScore, this.query(this.lastDoc));
    }

    private KeyIterable<ShardId, Row> doSearch(TopFieldCollectorManager topFieldCollectorManager, Float minScore, Query query) throws IOException {
        WrappingCollectorManager collectorManager = minScore == null ? new WrappingCollectorManager(topFieldCollectorManager, c -> new KillableCollector<TopFieldCollector>((TopFieldCollector)c, this::raiseIfKilled), c -> (TopFieldCollector)c.delegate) : new WrappingCollectorManager(topFieldCollectorManager, c -> new KillableCollector<MinimumScoreCollector<TopFieldCollector>>(new MinimumScoreCollector<TopFieldCollector>((TopFieldCollector)c, minScore.floatValue()), this::raiseIfKilled), c -> (TopFieldCollector)((MinimumScoreCollector)c.delegate).delegate());
        TopFieldDocs topFieldDocs = (TopFieldDocs)this.searcher.search(query, collectorManager);
        ScoreDoc[] scoreDocs = topFieldDocs.scoreDocs;
        if (this.doDocsScores) {
            TopFieldCollector.populateScores((ScoreDoc[])scoreDocs, (IndexSearcher)this.searcher, (Query)query);
        }
        return this.scoreDocToIterable(scoreDocs);
    }

    private KeyIterable<ShardId, Row> scoreDocToIterable(ScoreDoc[] scoreDocs) {
        boolean bl = this.exhausted = scoreDocs.length < this.batchSize;
        if (scoreDocs.length > 0) {
            this.lastDoc = (FieldDoc)scoreDocs[scoreDocs.length - 1];
        }
        return new KeyIterable<ShardId, Row>(this.shardId(), Lists.mapLazy(Arrays.asList(scoreDocs), (Function)this.rowFunction));
    }

    private Query query(FieldDoc lastDoc) {
        Query optimizedQuery = this.searchAfterQueryOptimize.apply(lastDoc);
        if (optimizedQuery == null) {
            return this.query;
        }
        BooleanQuery.Builder searchAfterQuery = new BooleanQuery.Builder();
        searchAfterQuery.add(this.query, BooleanClause.Occur.MUST);
        searchAfterQuery.add(optimizedQuery, BooleanClause.Occur.MUST_NOT);
        return searchAfterQuery.build();
    }

    private void raiseIfKilled() {
        Throwable t = this.killed.get();
        if (t != null) {
            Exceptions.rethrowUnchecked((Throwable)t);
        }
    }

    private static class KillableCollector<C extends Collector>
    implements Collector {
        private final C delegate;
        private final Runnable raiseIfKilled;

        public KillableCollector(C delegate, Runnable raiseIfKilled) {
            this.delegate = delegate;
            this.raiseIfKilled = raiseIfKilled;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.raiseIfKilled.run();
            return new KillableLeafCollector(this.delegate.getLeafCollector(context), this.raiseIfKilled);
        }

        public ScoreMode scoreMode() {
            return this.delegate.scoreMode();
        }
    }

    private static class KillableLeafCollector
    implements LeafCollector {
        private final LeafCollector delegate;
        private final Runnable raiseIfKilled;

        public KillableLeafCollector(LeafCollector delegate, Runnable raiseIfKilled) {
            this.delegate = delegate;
            this.raiseIfKilled = raiseIfKilled;
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.raiseIfKilled.run();
            this.delegate.setScorer(scorer);
        }

        public void collect(int doc) throws IOException {
            this.raiseIfKilled.run();
            this.delegate.collect(doc);
        }
    }
}

