/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.count;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.common.concurrent.CompletableFutures;
import io.crate.exceptions.JobKilledException;
import io.crate.execution.support.ThreadPools;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class CountOperation {
    private final LuceneQueryBuilder queryBuilder;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPoolExecutor executor;
    private final int numProcessors;
    private final Schemas schemas;

    @Inject
    public CountOperation(Settings settings, NodeContext nodeContext, LuceneQueryBuilder queryBuilder, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService) {
        this.schemas = nodeContext.schemas();
        this.queryBuilder = queryBuilder;
        this.clusterService = clusterService;
        this.executor = (ThreadPoolExecutor)threadPool.executor("search");
        this.indicesService = indicesService;
        this.numProcessors = EsExecutors.numberOfProcessors(settings);
    }

    public CompletableFuture<Long> count(TransactionContext txnCtx, Map<String, IntIndexedContainer> indexShardMap, Symbol filter, boolean onPartitionedTable) {
        ArrayList<CompletableFuture<Supplier<Long>>> futureSuppliers = new ArrayList<CompletableFuture<Supplier<Long>>>();
        Metadata metadata = this.clusterService.state().metadata();
        for (Map.Entry<String, IntIndexedContainer> entry : indexShardMap.entrySet()) {
            String indexUUID = entry.getKey();
            IndexMetadata indexMetadata = metadata.index(indexUUID);
            if (indexMetadata == null) {
                if (onPartitionedTable) continue;
                throw new IndexNotFoundException(indexUUID);
            }
            Index index = indexMetadata.getIndex();
            for (IntCursor shardCursor : entry.getValue()) {
                int shardValue = shardCursor.value;
                futureSuppliers.add(this.prepareGetCount(txnCtx, index, shardValue, filter, onPartitionedTable));
            }
        }
        MergePartialCountFunction mergeFunction = new MergePartialCountFunction();
        return ((CompletableFuture)CompletableFutures.allAsList(futureSuppliers).thenCompose(suppliers -> ThreadPools.runWithAvailableThreads(this.executor, ThreadPools.numIdleThreads(this.executor, this.numProcessors), suppliers))).thenApply((Function)mergeFunction);
    }

    public CompletableFuture<Supplier<Long>> prepareGetCount(TransactionContext txnCtx, Index index, int shardId, Symbol filter, boolean onPartitionedTable) {
        IndexService indexService;
        try {
            indexService = this.indicesService.indexServiceSafe(index);
        }
        catch (IndexNotFoundException e) {
            if (onPartitionedTable) {
                return CompletableFuture.completedFuture(() -> 0L);
            }
            return CompletableFuture.failedFuture(e);
        }
        IndexShard indexShard = indexService.getShard(shardId);
        CompletableFuture<Supplier<Long>> futureCount = new CompletableFuture<Supplier<Long>>();
        indexShard.awaitShardSearchActive(b -> {
            try {
                futureCount.complete(() -> this.syncCount(indexService, indexShard, txnCtx, filter, onPartitionedTable));
            }
            catch (Throwable t) {
                futureCount.completeExceptionally(t);
            }
        });
        return futureCount;
    }

    @VisibleForTesting
    long syncCount(IndexService indexService, IndexShard indexShard, TransactionContext txnCtx, Symbol filter, boolean onPartitionedTable) {
        Runnable raiseIfKilled = () -> {
            if (Thread.interrupted()) {
                throw JobKilledException.of("thread interrupted during count-operation");
            }
        };
        Engine.Searcher searcher = indexShard.acquireSearcher("count-operation");
        try {
            PartitionName partitionName = this.clusterService.state().metadata().getPartitionName(indexShard.shardId().getIndexUUID());
            DocTableInfo table = (DocTableInfo)this.schemas.getTableInfo(partitionName.relationName());
            LuceneQueryBuilder.Context queryCtx = this.queryBuilder.convert(filter, txnCtx, partitionName.values(), indexService.indexAnalyzers(), table, indexShard.getVersionCreated(), indexService.cache(), raiseIfKilled);
            raiseIfKilled.run();
            long l = searcher.count(queryCtx.query());
            if (searcher != null) {
                searcher.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (IllegalIndexShardStateException e) {
                if (onPartitionedTable) {
                    return 0L;
                }
                throw e;
            }
        }
    }

    private static class MergePartialCountFunction
    implements Function<List<Long>, Long> {
        private MergePartialCountFunction() {
        }

        @Override
        public Long apply(List<Long> partialResults) {
            long result = 0L;
            for (Long partialResult : partialResults) {
                result += partialResult.longValue();
            }
            return result;
        }
    }
}

