/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.CopyFromParserProperties;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.SkippingBatchIterator;
import io.crate.exceptions.UnauthorizedException;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.files.FileInputFactory;
import io.crate.execution.engine.collect.files.FileReadingIterator;
import io.crate.execution.engine.collect.files.LineCollectorExpression;
import io.crate.execution.engine.collect.files.LineProcessor;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.file.FileLineReferenceResolver;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.types.DataTypes;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class FileCollectSource
implements CollectSource {
    private final ClusterService clusterService;
    private final Map<String, FileInputFactory> fileInputFactoryMap;
    private final InputFactory inputFactory;
    private final NodeContext nodeCtx;
    private final ThreadPool threadPool;
    private final Roles roles;

    @Inject
    public FileCollectSource(NodeContext nodeCtx, ClusterService clusterService, Map<String, FileInputFactory> fileInputFactoryMap, ThreadPool threadPool, Roles roles) {
        this.fileInputFactoryMap = fileInputFactoryMap;
        this.nodeCtx = nodeCtx;
        this.inputFactory = new InputFactory(nodeCtx);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.roles = roles;
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase collectPhase, CollectTask collectTask, boolean supportMoveToStart) {
        FileUriCollectPhase fileUriCollectPhase = (FileUriCollectPhase)collectPhase;
        ReferenceResolver<LineCollectorExpression> referenceResolver = FileLineReferenceResolver::getImplementation;
        InputFactory.Context<LineCollectorExpression> ctx = this.inputFactory.ctxForRefs(txnCtx, referenceResolver);
        ctx.add(collectPhase.toCollect());
        Role user = Objects.requireNonNull(this.roles.findUser(txnCtx.sessionSettings().userName()), "User who invoked a statement must exist");
        List<URI> fileUris = FileCollectSource.targetUriToStringList(txnCtx, this.nodeCtx, fileUriCollectPhase.targetUri()).stream().map(s -> {
            URI uri = FileReadingIterator.toURI(s);
            if (uri.getScheme().equals("file") && !user.isSuperUser()) {
                throw new UnauthorizedException("Only a superuser can read from the local file system");
            }
            return uri;
        }).toList();
        FileReadingIterator fileReadingIterator = new FileReadingIterator(fileUris, fileUriCollectPhase.compression(), this.fileInputFactoryMap, fileUriCollectPhase.sharedStorage(), fileUriCollectPhase.nodeIds().size(), FileCollectSource.getReaderNumber(fileUriCollectPhase.nodeIds(), this.clusterService.state().nodes().getLocalNodeId()), fileUriCollectPhase.withClauseOptions(), this.threadPool.scheduler());
        CopyFromParserProperties parserProperties = fileUriCollectPhase.parserProperties();
        LineProcessor lineProcessor = new LineProcessor((BatchIterator<FileReadingIterator.LineCursor>)(parserProperties.skipNumLines() > 0L ? new SkippingBatchIterator((BatchIterator)fileReadingIterator, (int)parserProperties.skipNumLines()) : fileReadingIterator), ctx.topLevelInputs(), ctx.expressions(), fileUriCollectPhase.inputFormat(), parserProperties, fileUriCollectPhase.targetColumns());
        return CompletableFuture.completedFuture(lineProcessor);
    }

    @VisibleForTesting
    public static int getReaderNumber(Collection<String> nodeIds, String localNodeId) {
        Object[] readers = nodeIds.toArray(new String[0]);
        Arrays.sort(readers);
        return Arrays.binarySearch(readers, localNodeId);
    }

    private static List<String> targetUriToStringList(TransactionContext txnCtx, NodeContext nodeCtx, Symbol targetUri) {
        Object value = SymbolEvaluator.evaluate(txnCtx, nodeCtx, targetUri, Row.EMPTY, SubQueryResults.EMPTY);
        if (targetUri.valueType().id() == DataTypes.STRING.id()) {
            String uri = (String)value;
            return Collections.singletonList(uri);
        }
        if (DataTypes.STRING_ARRAY.equals(targetUri.valueType())) {
            return DataTypes.STRING_ARRAY.implicitCast(value);
        }
        throw AnalyzedCopyFrom.raiseInvalidType(targetUri.valueType());
    }
}

