/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.common.collections.Iterables;
import io.crate.common.collections.Iterators;
import io.crate.execution.engine.collect.files.SqlFeatureContext;
import io.crate.execution.engine.collect.files.SqlFeatures;
import io.crate.expression.reference.information.ColumnContext;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.fdw.ServersMetadata;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.IndexName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionInfo;
import io.crate.metadata.PartitionInfos;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.RoutineInfo;
import io.crate.metadata.RoutineInfos;
import io.crate.metadata.Schemas;
import io.crate.metadata.information.UserMappingOptionsTableInfo;
import io.crate.metadata.information.UserMappingsTableInfo;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.metadata.pgcatalog.PgClassTable;
import io.crate.metadata.pgcatalog.PgIndexTable;
import io.crate.metadata.pgcatalog.PgProcTable;
import io.crate.metadata.table.ConstraintInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.types.DataTypes;
import io.crate.types.Regclass;
import io.crate.types.Regproc;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class InformationSchemaIterables {
    private static final Set<String> IGNORED_SCHEMAS = Set.of("information_schema", "sys", "blob", "pg_catalog");
    private final Iterable<RelationInfo> relations;
    private final Iterable<TableInfo> tables;
    private final Iterable<ViewInfo> views;
    private final PartitionInfos partitionInfos;
    private final Iterable<ColumnContext> columns;
    private final Iterable<RelationInfo> primaryKeys;
    private final Iterable<ConstraintInfo> constraints;
    private final Iterable<ConstraintInfo> pgConstraints;
    private final Iterable<Void> referentialConstraints;
    private final Iterable<PgIndexTable.Entry> pgIndices;
    private final Iterable<PgClassTable.Entry> pgClasses;
    private final Iterable<PgProcTable.Entry> pgTypeReceiveFunctions;
    private final Iterable<PgProcTable.Entry> pgTypeSendFunctions;
    private final NodeContext nodeCtx;
    private final ClusterService clusterService;
    private final RoutineInfos routineInfos;
    private final Schemas schemas;

    @Inject
    public InformationSchemaIterables(NodeContext nodeCtx, FulltextAnalyzerResolver fulltextAnalyzerResolver, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.nodeCtx = nodeCtx;
        this.schemas = nodeCtx.schemas();
        this.views = () -> InformationSchemaIterables.viewsStream(this.schemas).iterator();
        this.tables = () -> InformationSchemaIterables.tablesStream(this.schemas).iterator();
        this.relations = () -> {
            Metadata metadata = clusterService.state().metadata();
            ForeignTablesMetadata foreignTables = metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
            return Stream.concat(Stream.concat(InformationSchemaIterables.tablesStream(this.schemas), InformationSchemaIterables.viewsStream(this.schemas)), StreamSupport.stream(foreignTables.spliterator(), false)).iterator();
        };
        this.primaryKeys = () -> Iterables.sequentialStream(this.relations).filter(this::isPrimaryKey).iterator();
        this.columns = () -> Iterables.sequentialStream(this.relations).flatMap(r -> Iterables.sequentialStream((Iterable)new ColumnsIterable((RelationInfo)r))).iterator();
        Iterable primaryKeyConstraints = () -> Iterables.sequentialStream(this.primaryKeys).map(t -> new ConstraintInfo((RelationInfo)t, t.pkConstraintNameOrDefault(), ConstraintInfo.Type.PRIMARY_KEY)).iterator();
        Iterable notnullConstraints = () -> Iterables.sequentialStream(this.relations).flatMap(r -> Iterables.sequentialStream((Iterable)new NotNullConstraintIterable((RelationInfo)r))).iterator();
        Iterable checkConstraints = () -> Iterables.sequentialStream(this.relations).flatMap(r -> r.checkConstraints().stream().map(chk -> new ConstraintInfo((RelationInfo)r, chk.name(), ConstraintInfo.Type.CHECK))).iterator();
        this.constraints = () -> Stream.of(Iterables.sequentialStream((Iterable)primaryKeyConstraints), Iterables.sequentialStream((Iterable)notnullConstraints), Iterables.sequentialStream((Iterable)checkConstraints)).flatMap(Function.identity()).iterator();
        this.pgConstraints = () -> Stream.of(Iterables.sequentialStream((Iterable)primaryKeyConstraints), Iterables.sequentialStream((Iterable)checkConstraints)).flatMap(Function.identity()).iterator();
        this.partitionInfos = new PartitionInfos(clusterService, this.schemas);
        this.routineInfos = new RoutineInfos(fulltextAnalyzerResolver, clusterService);
        this.referentialConstraints = Collections.emptyList();
        this.pgIndices = () -> InformationSchemaIterables.tablesStream(this.schemas).filter(this::isPrimaryKey).map(this::pgIndex).iterator();
        this.pgClasses = () -> Stream.concat(Iterables.sequentialStream(this.relations).map(this::relationToPgClassEntry), Iterables.sequentialStream(this.primaryKeys).map(this::primaryKeyToPgClassEntry)).iterator();
        this.pgTypeReceiveFunctions = () -> Stream.concat(Iterables.sequentialStream(PGTypes.pgTypes()).filter(t -> t.typArray() != 0).map(x -> x.typReceive().asDummySignature()).map(PgProcTable.Entry::of), Stream.of(PgProcTable.Entry.of(Regproc.of("array_recv").asDummySignature()))).iterator();
        this.pgTypeSendFunctions = () -> Stream.concat(Iterables.sequentialStream(PGTypes.pgTypes()).filter(t -> t.typArray() != 0).map(x -> x.typSend().asDummySignature()).map(PgProcTable.Entry::of), Stream.of(PgProcTable.Entry.of(Regproc.of("array_send").asDummySignature()))).iterator();
    }

    private boolean isPrimaryKey(RelationInfo relationInfo) {
        return relationInfo.primaryKey().size() > 1 || relationInfo.primaryKey().size() == 1 && !relationInfo.primaryKey().get(0).name().equals("_id");
    }

    private PgClassTable.Entry relationToPgClassEntry(RelationInfo info) {
        return new PgClassTable.Entry(Regclass.relationOid(info), OidHash.schemaOid(info.ident().schema()), info.ident(), info.ident().name(), InformationSchemaIterables.toEntryType(info.relationType()), info.rootColumns().size(), !info.primaryKey().isEmpty());
    }

    private PgClassTable.Entry primaryKeyToPgClassEntry(RelationInfo info) {
        return new PgClassTable.Entry(Regclass.primaryOid(info), OidHash.schemaOid(info.ident().schema()), info.ident(), info.pkConstraintNameOrDefault(), PgClassTable.Entry.Type.INDEX, info.rootColumns().size(), !info.primaryKey().isEmpty());
    }

    private static PgClassTable.Entry.Type toEntryType(RelationInfo.RelationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RelationInfo.RelationType.BASE_TABLE -> PgClassTable.Entry.Type.RELATION;
            case RelationInfo.RelationType.VIEW -> PgClassTable.Entry.Type.VIEW;
            case RelationInfo.RelationType.FOREIGN -> PgClassTable.Entry.Type.FOREIGN;
        };
    }

    private PgIndexTable.Entry pgIndex(TableInfo tableInfo) {
        List<ColumnIdent> primaryKey = tableInfo.primaryKey();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (ColumnIdent columnIdent : primaryKey) {
            Reference pkRef = tableInfo.getReference(columnIdent);
            assert (pkRef != null) : "`getReference(..)` must not return null for columns retrieved from `primaryKey()`";
            int position = pkRef.position();
            positions.add(position);
        }
        return new PgIndexTable.Entry(Regclass.relationOid(tableInfo), Regclass.primaryOid(tableInfo), positions);
    }

    private static Stream<ViewInfo> viewsStream(Schemas schemas) {
        return Iterables.sequentialStream((Iterable)schemas).flatMap(schema -> Iterables.sequentialStream(schema.getViews())).filter(i -> !IndexName.isPartitioned(i.ident().indexNameOrAlias()));
    }

    public static Stream<TableInfo> tablesStream(Schemas schemas) {
        return Iterables.sequentialStream((Iterable)schemas).flatMap(s -> Iterables.sequentialStream(s.getTables()));
    }

    public Iterable<SchemaInfo> schemas() {
        return this.nodeCtx.schemas();
    }

    public Iterable<RelationInfo> relations() {
        return this.relations;
    }

    public Iterable<TableInfo> tables() {
        return this.tables;
    }

    public Iterable<PgIndexTable.Entry> pgIndices() {
        return this.pgIndices;
    }

    public Iterable<ViewInfo> views() {
        return this.views;
    }

    public Iterable<PartitionInfo> partitions() {
        return this.partitionInfos;
    }

    public Iterable<ColumnContext> columns() {
        return this.columns;
    }

    public Iterable<ConstraintInfo> constraints() {
        return this.constraints;
    }

    public Iterable<ConstraintInfo> pgConstraints() {
        return this.pgConstraints;
    }

    public Iterable<RoutineInfo> routines() {
        return this.routineInfos;
    }

    public Iterable<SqlFeatureContext> features() {
        try {
            return SqlFeatures.loadFeatures();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Iterable<PgClassTable.Entry> pgClasses() {
        return this.pgClasses;
    }

    public Iterable<PgProcTable.Entry> pgProc() {
        return () -> Stream.concat(Iterables.sequentialStream(this.nodeCtx.functions().signatures()).map(PgProcTable.Entry::of), Stream.concat(Iterables.sequentialStream(this.pgTypeReceiveFunctions), Iterables.sequentialStream(this.pgTypeSendFunctions))).iterator();
    }

    public Iterable<KeyColumnUsage> keyColumnUsage() {
        return Iterables.sequentialStream(this.primaryKeys).filter(tableInfo -> !IGNORED_SCHEMAS.contains(tableInfo.ident().schema())).flatMap(tableInfo -> {
            List<ColumnIdent> pks = tableInfo.primaryKey();
            PrimitiveIterator.OfInt ids = IntStream.range(1, pks.size() + 1).iterator();
            RelationName ident = tableInfo.ident();
            return pks.stream().map(pk -> new KeyColumnUsage(ident, tableInfo.pkConstraintNameOrDefault(), (ColumnIdent)pk, ids.next()));
        })::iterator;
    }

    public Iterable<Void> referentialConstraintsInfos() {
        return this.referentialConstraints;
    }

    public Iterable<ServersMetadata.Server> servers() {
        Metadata metadata = this.clusterService.state().metadata();
        return metadata.custom("servers", ServersMetadata.EMPTY);
    }

    public Iterable<ServersMetadata.Server.Option> serverOptions() {
        Metadata metadata = this.clusterService.state().metadata();
        ServersMetadata servers = metadata.custom("servers", ServersMetadata.EMPTY);
        return servers.getOptions();
    }

    public Iterable<UserMappingsTableInfo.UserMapping> userMappings() {
        Metadata metadata = this.clusterService.state().metadata();
        ServersMetadata servers = metadata.custom("servers", ServersMetadata.EMPTY);
        return servers.getUserMappings();
    }

    public Iterable<UserMappingOptionsTableInfo.UserMappingOptions> userMappingOptions() {
        Metadata metadata = this.clusterService.state().metadata();
        ServersMetadata servers = metadata.custom("servers", ServersMetadata.EMPTY);
        return servers.getUserMappingOptions();
    }

    public Iterable<ForeignTable> foreignTables() {
        Metadata metadata = this.clusterService.state().metadata();
        return metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
    }

    public Iterable<ForeignTable.Option> foreignTableOptions() {
        Metadata metadata = this.clusterService.state().metadata();
        ForeignTablesMetadata foreignTables = metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        return foreignTables.tableOptions();
    }

    public Iterable<String> enabledRoles(Role role, Roles roles) {
        boolean isAdmin = roles.hasALPrivileges(role);
        return () -> Iterators.concat((Iterator[])new Iterator[]{List.of(role.name()).iterator(), this.applicableRoles(role, roles, isAdmin).map(ApplicableRole::roleName).distinct().iterator()});
    }

    public Iterable<ApplicableRole> administrableRoleAuthorizations(Role role, Roles roles) {
        boolean isAdmin = roles.hasALPrivileges(role);
        return () -> this.applicableRoles(role, roles, isAdmin).filter(ApplicableRole::isGrantable).iterator();
    }

    public Iterable<ApplicableRole> applicableRoles(Role role, Roles roles) {
        boolean isAdmin = roles.hasALPrivileges(role);
        return () -> this.applicableRoles(role, roles, isAdmin).iterator();
    }

    private Stream<ApplicableRole> applicableRoles(Role role, Roles roles, boolean isAdmin) {
        return role.grantedRoles().stream().mapMulti((grantedRole, c) -> {
            c.accept(new ApplicableRole(role.name(), grantedRole.roleName(), false));
            c.accept(new ApplicableRole(grantedRole.grantor(), grantedRole.roleName(), isAdmin));
            Role retrievedRole = roles.findRole(grantedRole.roleName());
            if (retrievedRole != null) {
                this.applicableRoles(retrievedRole, roles, isAdmin).forEach((Consumer<ApplicableRole>)c);
            }
        });
    }

    public Iterable<RoleTableGrant> roleTableGrants(Role role, Roles roles) {
        boolean isAdmin = roles.hasALPrivileges(role);
        return () -> this.roleTableGrants(role, role, roles, isAdmin).distinct().iterator();
    }

    private Stream<RoleTableGrant> roleTableGrants(Role user, Role role, Roles roles, boolean isAdmin) {
        Stream roleStream = StreamSupport.stream(role.privileges().spliterator(), false).mapMulti((p, c) -> {
            Securable securableType = p.subject().securable();
            if (!roles.hasPrivilege(user, p.subject().permission(), securableType, p.subject().ident())) {
                return;
            }
            switch (securableType) {
                case TABLE: 
                case VIEW: {
                    String fqn = p.subject().ident();
                    assert (fqn != null) : "fqn must not be null for securable type TABLE";
                    RelationName ident = RelationName.fromIndexName(fqn);
                    c.accept(new RoleTableGrant(p.grantor(), role.name(), "crate", ident.schema(), ident.name(), p.subject().permission().name(), isAdmin, false));
                    break;
                }
                case SCHEMA: {
                    SchemaInfo schemaInfo = this.schemas.getSchemaInfo(p.subject().ident());
                    if (schemaInfo == null) break;
                    schemaInfo.getTables().forEach(tableInfo -> c.accept(new RoleTableGrant(p.grantor(), role.name(), "crate", schemaInfo.name(), tableInfo.ident().name(), p.subject().permission().name(), isAdmin, false)));
                    break;
                }
            }
        });
        Stream parentsStream = role.grantedRoles().stream().mapMulti((grantedRole, c) -> {
            Role retrievedRole = roles.findRole(grantedRole.roleName());
            if (retrievedRole != null) {
                this.roleTableGrants(user, retrievedRole, roles, isAdmin).forEach((Consumer<RoleTableGrant>)c);
            }
        });
        return Stream.concat(roleStream, parentsStream);
    }

    public record RoleTableGrant(String grantor, String grantee, String tableCatalog, String tableSchema, String tableName, String privilegeType, boolean isGrantable, boolean withHierarchy) {
    }

    public record ApplicableRole(String grantee, String roleName, boolean isGrantable) {
    }

    public record KeyColumnUsage(RelationName relationName, String pkName, ColumnIdent pkColumnIdent, int ordinal) {
        public String getSchema() {
            return this.relationName.schema();
        }

        public String getTableName() {
            return this.relationName.name();
        }

        public String getFQN() {
            return this.relationName.fqn();
        }
    }

    static class NotNullConstraintIterable
    implements Iterable<ConstraintInfo> {
        private final RelationInfo info;

        NotNullConstraintIterable(RelationInfo info) {
            this.info = info;
        }

        @Override
        @NotNull
        public Iterator<ConstraintInfo> iterator() {
            return new NotNullConstraintIterator(this.info);
        }
    }

    static class ColumnsIterable
    implements Iterable<ColumnContext> {
        private final RelationInfo relationInfo;

        ColumnsIterable(RelationInfo relationInfo) {
            this.relationInfo = relationInfo;
        }

        @Override
        @NotNull
        public Iterator<ColumnContext> iterator() {
            return new ColumnsIterator(this.relationInfo);
        }
    }

    static class ColumnsIterator
    implements Iterator<ColumnContext> {
        private final Iterator<Reference> columns;
        private final RelationInfo tableInfo;

        ColumnsIterator(RelationInfo tableInfo) {
            this.columns = Stream.concat(StreamSupport.stream(tableInfo.spliterator(), false), tableInfo.droppedColumns().stream()).filter(reference -> !reference.column().isSystemColumn() && reference.valueType() != DataTypes.NOT_SUPPORTED).iterator();
            this.tableInfo = tableInfo;
        }

        @Override
        public boolean hasNext() {
            return this.columns.hasNext();
        }

        @Override
        public ColumnContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Columns iterator exhausted");
            }
            return new ColumnContext(this.tableInfo, this.columns.next());
        }
    }

    static class NotNullConstraintIterator
    implements Iterator<ConstraintInfo> {
        private final RelationInfo relationInfo;
        private final Iterator<Reference> notNullableColumns;

        NotNullConstraintIterator(RelationInfo relationInfo) {
            this.relationInfo = relationInfo;
            this.notNullableColumns = StreamSupport.stream(relationInfo.spliterator(), false).filter(reference -> !reference.column().isSystemColumn() && reference.valueType() != DataTypes.NOT_SUPPORTED && !reference.isNullable()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.notNullableColumns.hasNext();
        }

        @Override
        public ConstraintInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Not null constraint iterator exhausted");
            }
            String constraintName = this.relationInfo.ident().schema() + "_" + this.relationInfo.ident().name() + "_" + this.notNullableColumns.next().column().name() + "_not_null";
            return new ConstraintInfo(this.relationInfo, constraintName, ConstraintInfo.Type.CHECK);
        }
    }
}

