/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.Streamer;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.distribution.MultiBucketBuilder;
import io.crate.execution.engine.distribution.StreamBucket;

public class BroadcastingBucketBuilder
implements MultiBucketBuilder {
    private final int numBuckets;
    private final StreamBucket.Builder bucketBuilder;

    public BroadcastingBucketBuilder(Streamer<?>[] streamers, int numBuckets, RamAccounting ramAccounting) {
        this.numBuckets = numBuckets;
        this.bucketBuilder = new StreamBucket.Builder(streamers, ramAccounting);
    }

    @Override
    public void add(Row row) {
        this.bucketBuilder.add(row);
    }

    @Override
    public int size() {
        return this.bucketBuilder.size();
    }

    public long ramBytesUsed() {
        return this.bucketBuilder.ramBytesUsed();
    }

    @Override
    public void build(StreamBucket[] buckets) {
        assert (buckets.length == this.numBuckets) : "length of the provided array must match numBuckets";
        StreamBucket bucket = this.bucketBuilder.build();
        this.bucketBuilder.reset();
        for (int i = 0; i < this.numBuckets; ++i) {
            buckets[i] = bucket;
        }
    }
}

