/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import io.crate.common.collections.Iterables;
import io.crate.common.collections.Iterators;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PassThroughPagingIterator<TKey, TRow>
implements PagingIterator<TKey, TRow> {
    private Iterator<TRow> iterator = Collections.emptyIterator();
    private final ArrayList<KeyIterable<TKey, TRow>> iterables = new ArrayList();
    private final boolean repeatable;
    private Iterable<TRow> storedForRepeat = null;

    private PassThroughPagingIterator(boolean repeatable) {
        this.repeatable = repeatable;
    }

    public static <TKey, TRow> PassThroughPagingIterator<TKey, TRow> repeatable() {
        return new PassThroughPagingIterator<TKey, TRow>(true);
    }

    public static <TKey, TRow> PassThroughPagingIterator<TKey, TRow> oneShot() {
        return new PassThroughPagingIterator<TKey, TRow>(false);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public TRow next() {
        return this.iterator.next();
    }

    @Override
    public void merge(Iterable<? extends KeyIterable<TKey, TRow>> iterables) {
        Iterable concat = Iterables.concat(iterables);
        if (this.repeatable) {
            for (KeyIterable<TKey, TRow> iterable : iterables) {
                this.iterables.add(iterable);
            }
            this.storedForRepeat = null;
        }
        this.iterator = this.iterator.hasNext() ? Iterators.concat((Iterator[])new Iterator[]{this.iterator, concat.iterator()}) : concat.iterator();
    }

    @Override
    public void finish() {
    }

    @Override
    public TKey exhaustedIterable() {
        return null;
    }

    @Override
    public Iterable<TRow> repeat() {
        if (!this.repeatable) {
            throw new IllegalStateException("Can't repeat a non-repeatable iterator");
        }
        Iterable repeatMe = this.storedForRepeat;
        if (repeatMe == null) {
            this.storedForRepeat = repeatMe = Iterables.concat(List.copyOf(this.iterables));
        }
        return repeatMe;
    }
}

