/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.Streamer;
import io.crate.common.collections.BorrowedItem;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.fetch.FetchTask;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.InputRow;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.metadata.doc.DocTableInfo;
import io.netty.util.collection.IntObjectHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class FetchCollector {
    private final LuceneCollectorExpression<?>[] collectorExpressions;
    private final InputRow row;
    private final Streamer<?>[] streamers;
    private final RamAccounting ramAccounting;
    private final int readerId;
    private final FetchTask fetchTask;

    FetchCollector(List<LuceneCollectorExpression<?>> collectorExpressions, List<String> partitionValues, Streamer<?>[] streamers, FetchTask fetchTask, RamAccounting ramAccounting, int readerId) {
        this.fetchTask = fetchTask;
        this.collectorExpressions = collectorExpressions.toArray(new LuceneCollectorExpression[0]);
        this.streamers = streamers;
        this.ramAccounting = ramAccounting;
        this.readerId = readerId;
        DocTableInfo table = fetchTask.table(readerId);
        Version shardCreatedVersion = fetchTask.indexShard(readerId).getVersionCreated();
        CollectorContext collectorContext = new CollectorContext(readerId, () -> StoredRowLookup.create(shardCreatedVersion, table, partitionValues));
        for (LuceneCollectorExpression<?> collectorExpression : this.collectorExpressions) {
            collectorExpression.startCollect(collectorContext);
        }
        this.row = new InputRow(collectorExpressions);
    }

    private void setNextDocId(ReaderContext readerContext, int doc) throws IOException {
        for (LuceneCollectorExpression<?> e : this.collectorExpressions) {
            e.setNextReader(readerContext);
            e.setNextDocId(doc);
        }
    }

    public StreamBucket collect(IntArrayList docIds) {
        boolean collectSequential = FetchCollector.isSequential(docIds);
        StreamBucket.Builder builder = new StreamBucket.Builder(this.streamers, this.ramAccounting);
        try (BorrowedItem<IndexSearcher> borrowed = this.fetchTask.searcher(this.readerId);){
            IndexSearcher searcher = (IndexSearcher)borrowed.item();
            List leaves = searcher.getTopReaderContext().leaves();
            IntObjectHashMap readerContexts = new IntObjectHashMap(leaves.size());
            for (IntCursor cursor : docIds) {
                int docId = cursor.value;
                int readerIndex = this.readerIndex(docId, leaves);
                LeafReaderContext subReaderContext = (LeafReaderContext)leaves.get(readerIndex);
                try {
                    ReaderContext readerContext = (ReaderContext)readerContexts.get(readerIndex);
                    if (readerContext == null) {
                        LeafReader leafReader;
                        if (collectSequential && (leafReader = subReaderContext.reader()) instanceof SequentialStoredFieldsLeafReader) {
                            SequentialStoredFieldsLeafReader storedFieldsLeafReader = (SequentialStoredFieldsLeafReader)leafReader;
                            StoredFieldsReader sequentialStoredFieldsReader = storedFieldsLeafReader.getSequentialStoredFieldsReader();
                            readerContext = new ReaderContext(subReaderContext, (arg_0, arg_1) -> ((StoredFieldsReader)sequentialStoredFieldsReader).document(arg_0, arg_1));
                        } else {
                            readerContext = new ReaderContext(subReaderContext);
                        }
                        readerContexts.put(readerIndex, (Object)readerContext);
                    }
                    this.setNextDocId(readerContext, docId - subReaderContext.docBase);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                builder.add(this.row);
            }
        }
        return builder.build();
    }

    private int readerIndex(int docId, List<LeafReaderContext> leaves) {
        int readerIndex = ReaderUtil.subIndex((int)docId, leaves);
        if (readerIndex == -1) {
            throw new IllegalStateException("jobId=" + String.valueOf(this.fetchTask.jobId()) + " docId " + docId + " doesn't fit to leaves of searcher " + this.readerId + " fetchTask=" + String.valueOf(this.fetchTask));
        }
        return readerIndex;
    }

    static boolean isSequential(IntArrayList docIds) {
        int first;
        if (docIds.size() < 2) {
            return false;
        }
        int last = docIds.get(docIds.size() - 1);
        return last - (first = docIds.get(0)) == docIds.size() - 1;
    }
}

