/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.UnsafeArrayRow;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.ItemFactory;
import io.crate.execution.engine.indexing.RowSourceInfo;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.metadata.PartitionName;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.index.IndexNotFoundException;
import org.jetbrains.annotations.Nullable;

public final class GroupRowsByShard<TReq extends ShardRequest<TReq, TItem>, TItem extends ShardRequest.Item>
implements TriFunction<ShardedRequests<TReq, TItem>, Row, Boolean, TItem>,
BiConsumer<ShardedRequests<TReq, TItem>, Row> {
    private static final Logger LOGGER = LogManager.getLogger(GroupRowsByShard.class);
    private final RowShardResolver rowShardResolver;
    private final List<? extends CollectExpression<Row, ?>> expressions;
    private final List<? extends CollectExpression<Row, ?>> sourceInfoExpressions;
    private final ItemFactory<TItem> itemFactory;
    private final Supplier<PartitionName> partitionResolver;
    private final ClusterService clusterService;
    private final boolean autoCreateIndices;
    private final BiConsumer<ShardedRequests, String> itemFailureRecorder;
    private final Predicate<ShardedRequests> hasSourceFailure;
    private final Input<String> sourceUriInput;
    private final Input<Long> lineNumberInput;
    private final UnsafeArrayRow spareRow = new UnsafeArrayRow();
    private Object[] spareCells;
    private final BiConsumer<PartitionName, IndexItem> constraintsChecker;

    public GroupRowsByShard(ClusterService clusterService, BiConsumer<PartitionName, IndexItem> constraintsChecker, RowShardResolver rowShardResolver, Supplier<PartitionName> partitionResolver, List<? extends CollectExpression<Row, ?>> expressions, ItemFactory<TItem> itemFactory, boolean autoCreateIndices, UpsertResultContext upsertContext) {
        assert (expressions instanceof RandomAccess) : "expressions should be a RandomAccess list for zero allocation iterations";
        this.clusterService = clusterService;
        this.constraintsChecker = constraintsChecker;
        this.rowShardResolver = rowShardResolver;
        this.partitionResolver = partitionResolver;
        this.expressions = expressions;
        this.sourceInfoExpressions = upsertContext.getSourceInfoExpressions();
        this.itemFactory = itemFactory;
        this.itemFailureRecorder = upsertContext.getItemFailureRecorder();
        this.hasSourceFailure = upsertContext.getHasSourceFailureChecker();
        this.sourceUriInput = upsertContext.getSourceUriInput();
        this.lineNumberInput = upsertContext.getLineNumberInput();
        this.autoCreateIndices = autoCreateIndices;
    }

    @Override
    public void accept(ShardedRequests<TReq, TItem> shardedRequests, Row row) {
        this.apply(shardedRequests, row, false);
    }

    @Override
    public TItem apply(ShardedRequests<TReq, TItem> shardedRequests, Row row, Boolean propagateError) {
        int i;
        if (this.spareCells == null) {
            this.spareCells = new Object[row.numColumns()];
            this.spareRow.cells(this.spareCells);
        }
        Throwable err = null;
        for (int c = 0; c < row.numColumns(); ++c) {
            try {
                this.spareCells[c] = row.get(c);
                continue;
            }
            catch (Throwable t) {
                err = t;
            }
        }
        for (i = 0; i < this.sourceInfoExpressions.size(); ++i) {
            this.sourceInfoExpressions.get(i).setNextRow((Row)this.spareRow);
        }
        if (this.hasSourceFailure.test(shardedRequests)) {
            return null;
        }
        if (err != null) {
            this.itemFailureRecorder.accept(shardedRequests, err.getMessage());
            return null;
        }
        try {
            ShardLocation shardLocation;
            this.rowShardResolver.setNextRow((Row)this.spareRow);
            for (i = 0; i < this.expressions.size(); ++i) {
                this.expressions.get(i).setNextRow((Row)this.spareRow);
            }
            String id = this.rowShardResolver.id();
            ShardRequest.Item item = (ShardRequest.Item)this.itemFactory.create(id, this.rowShardResolver.pkValues(), this.rowShardResolver.autoGeneratedTimestamp());
            PartitionName partitionName = this.partitionResolver.get();
            ClusterState state = this.clusterService.state();
            IndexMetadata indexMetadata = state.metadata().getIndex(partitionName.relationName(), partitionName.values(), true, x -> x);
            String routing = this.rowShardResolver.routing();
            String sourceUri = (String)this.sourceUriInput.value();
            Long lineNumber = (Long)this.lineNumberInput.value();
            RowSourceInfo rowSourceInfo = RowSourceInfo.emptyMarkerOrNewInstance(sourceUri, lineNumber);
            ShardLocation shardLocation2 = shardLocation = indexMetadata == null ? null : this.getShardLocation(state, indexMetadata, id, routing);
            if (shardLocation == null) {
                if (item instanceof IndexItem) {
                    IndexItem indexItem = (IndexItem)((Object)item);
                    this.constraintsChecker.accept(partitionName, indexItem);
                }
                shardedRequests.add(item, partitionName, routing, rowSourceInfo);
            } else {
                shardedRequests.add(item, shardLocation, rowSourceInfo);
            }
            return (TItem)item;
        }
        catch (CircuitBreakingException e) {
            throw e;
        }
        catch (Throwable t) {
            if (propagateError.booleanValue()) {
                throw t;
            }
            this.itemFailureRecorder.accept(shardedRequests, t.getMessage());
            return null;
        }
    }

    @Nullable
    private ShardLocation getShardLocation(ClusterState state, IndexMetadata indexMetadata, String id, @Nullable String routing) {
        try {
            int shardId = OperationRouting.generateShardId(indexMetadata, id, routing);
            RoutingTable routingTable = state.routingTable();
            String indexUUID = indexMetadata.getIndexUUID();
            ShardIterator shardIterator = routingTable.shardRoutingTable(indexUUID, shardId).shardsIt();
            ShardRouting shardRouting = shardIterator.nextOrNull();
            String nodeId = shardRouting == null ? null : (!shardRouting.active() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId());
            if (nodeId == null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to get the node id for index {} and shard {}", (Object)indexUUID, (Object)id);
            }
            return new ShardLocation(shardIterator.shardId(), nodeId);
        }
        catch (IndexNotFoundException e) {
            if (!this.autoCreateIndices) {
                throw e;
            }
            return null;
        }
    }

    void reResolveShardLocations(ShardedRequests<TReq, TItem> requests) {
        Iterator entryIt = requests.itemsByMissingPartition.entrySet().iterator();
        ClusterState state = this.clusterService.state();
        Metadata metadata = state.metadata();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            PartitionName partitionName = entry.getKey();
            List items = entry.getValue();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                ShardedRequests.ItemAndRoutingAndSourceInfo itemAndRoutingAndSourceInfo = it.next();
                IndexMetadata indexMetadata = metadata.getIndex(partitionName.relationName(), partitionName.values(), true, x -> x);
                ShardLocation shardLocation = this.getShardLocation(state, indexMetadata, ((ShardRequest.Item)itemAndRoutingAndSourceInfo.item).id(), itemAndRoutingAndSourceInfo.routing);
                if (shardLocation == null) {
                    throw new IllegalStateException("shardLocation not resolvable after createIndices");
                }
                requests.add((ShardRequest.Item)itemAndRoutingAndSourceInfo.item, shardLocation, itemAndRoutingAndSourceInfo.rowSourceInfo);
                it.remove();
            }
            if (!items.isEmpty()) continue;
            entryIt.remove();
        }
    }
}

