/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.engine.indexing.RowSourceInfo;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.metadata.PartitionName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.shard.ShardId;

public final class ShardedRequests<TReq extends ShardRequest<TReq, TItem>, TItem extends ShardRequest.Item>
implements Releasable,
Accountable {
    final Map<PartitionName, List<ItemAndRoutingAndSourceInfo<TItem>>> itemsByMissingPartition = new HashMap<PartitionName, List<ItemAndRoutingAndSourceInfo<TItem>>>();
    final Map<String, List<ReadFailureAndLineNumber>> itemsWithFailureBySourceUri = new HashMap<String, List<ReadFailureAndLineNumber>>();
    final Map<String, String> sourceUrisWithFailure = new HashMap<String, String>();
    final List<RowSourceInfo> rowSourceInfos = new ArrayList<RowSourceInfo>();
    final Map<ShardLocation, TReq> itemsByShard = new HashMap<ShardLocation, TReq>();
    private final Function<ShardId, TReq> requestFactory;
    private final RamAccounting ramAccounting;
    private int location = -1;
    private long usedMemoryEstimate = 0L;

    public ShardedRequests(Function<ShardId, TReq> requestFactory, RamAccounting ramAccounting) {
        this.requestFactory = requestFactory;
        this.ramAccounting = ramAccounting;
    }

    public void add(TItem item, PartitionName partitionName2, String routing, RowSourceInfo rowSourceInfo) {
        long itemSizeInBytes = ((ShardRequest.Item)item).ramBytesUsed();
        this.ramAccounting.addBytes(itemSizeInBytes);
        this.usedMemoryEstimate += itemSizeInBytes;
        List items = this.itemsByMissingPartition.computeIfAbsent(partitionName2, partitionName -> new ArrayList());
        items.add(new ItemAndRoutingAndSourceInfo<TItem>(item, routing, rowSourceInfo));
    }

    public void add(TItem item, ShardLocation shardLocation, RowSourceInfo rowSourceInfo) {
        long itemSizeInBytes = ((ShardRequest.Item)item).ramBytesUsed();
        this.ramAccounting.addBytes(itemSizeInBytes);
        this.usedMemoryEstimate += itemSizeInBytes;
        ShardRequest req = (ShardRequest)this.itemsByShard.get(shardLocation);
        if (req == null) {
            req = (ShardRequest)this.requestFactory.apply(shardLocation.shardId);
            this.itemsByShard.put(shardLocation, req);
        }
        ++this.location;
        req.add(this.location, item);
        this.rowSourceInfos.add(rowSourceInfo);
    }

    public long ramBytesUsed() {
        return this.usedMemoryEstimate;
    }

    void addFailedItem(String sourceUri, String readFailure, Long lineNumber) {
        List itemsWithFailure = this.itemsWithFailureBySourceUri.computeIfAbsent(sourceUri, string -> new ArrayList());
        itemsWithFailure.add(new ReadFailureAndLineNumber(readFailure, lineNumber));
    }

    void addFailedUri(String sourceUri, String uriReadFailure) {
        assert (this.sourceUrisWithFailure.get(sourceUri) == null) : "A failure was already stored for this URI, should happen only once";
        this.sourceUrisWithFailure.put(sourceUri, uriReadFailure);
    }

    public Map<PartitionName, List<ItemAndRoutingAndSourceInfo<TItem>>> itemsByMissingPartition() {
        return this.itemsByMissingPartition;
    }

    public Map<ShardLocation, TReq> itemsByShard() {
        return this.itemsByShard;
    }

    @Override
    public void close() {
        this.ramAccounting.addBytes(-this.usedMemoryEstimate);
        this.usedMemoryEstimate = 0L;
    }

    public String toString() {
        return "ShardedRequests{numShards=" + this.itemsByShard.size() + ", bytesUsed=" + this.usedMemoryEstimate + ", sizePerShard=" + this.usedMemoryEstimate / (long)Math.max(1, this.itemsByShard.size()) + "}";
    }

    public static class ItemAndRoutingAndSourceInfo<TItem> {
        final TItem item;
        final String routing;
        final RowSourceInfo rowSourceInfo;

        ItemAndRoutingAndSourceInfo(TItem item, String routing, RowSourceInfo rowSourceInfo) {
            this.item = item;
            this.routing = routing;
            this.rowSourceInfo = rowSourceInfo;
        }

        public String routing() {
            return this.routing;
        }

        public TItem item() {
            return this.item;
        }
    }

    static class ReadFailureAndLineNumber {
        final String readFailure;
        final long lineNumber;

        ReadFailureAndLineNumber(String readFailure, long lineNumber) {
            this.readFailure = readFailure;
            this.lineNumber = lineNumber;
        }
    }
}

