/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.common.concurrent.ConcurrencyLimit;
import io.crate.common.unit.TimeValue;
import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Row;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.upsert.ShardUpsertAction;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.BatchIteratorBackpressureExecutor;
import io.crate.execution.engine.indexing.BulkShardCreationLimiter;
import io.crate.execution.engine.indexing.GroupRowsByShard;
import io.crate.execution.engine.indexing.IsUsedBytesOverThreshold;
import io.crate.execution.engine.indexing.ItemFactory;
import io.crate.execution.engine.indexing.RowSourceInfo;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.UpsertResultCollector;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.engine.indexing.UpsertResults;
import io.crate.execution.jobs.NodeLimits;
import io.crate.metadata.PartitionName;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreatePartitions;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkRequestExecutor;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.index.shard.ShardId;

public class ShardingUpsertExecutor
implements Function<BatchIterator<Row>, CompletableFuture<? extends Iterable<? extends Row>>> {
    public static final Setting<TimeValue> BULK_REQUEST_TIMEOUT_SETTING = Setting.positiveTimeSetting("bulk.request_timeout", new TimeValue(1L, TimeUnit.MINUTES), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final int BULK_RESPONSE_MAX_ERRORS_PER_SHARD = 10;
    static final Logger LOGGER = LogManager.getLogger(ShardingUpsertExecutor.class);
    static final double BREAKER_LIMIT_PERCENTAGE = 0.5;
    private final GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> grouper;
    private final NodeLimits nodeLimits;
    private final ScheduledExecutorService scheduler;
    private final Executor executor;
    private final int bulkSize;
    private final UUID jobId;
    private final Function<ShardId, ShardUpsertRequest> requestFactory;
    private final BulkRequestExecutor<ShardUpsertRequest> requestExecutor;
    private final Client elasticsearchClient;
    private final BulkShardCreationLimiter bulkShardCreationLimiter;
    private final UpsertResultCollector resultCollector;
    private final boolean isDebugEnabled;
    private final CircuitBreaker queryCircuitBreaker;
    private final String localNode;
    private final BlockBasedRamAccounting ramAccounting;
    private volatile boolean createPartitionsRequestOngoing = false;
    private final Predicate<UpsertResults> earlyTerminationCondition;
    private final Function<UpsertResults, Throwable> earlyTerminationExceptionGenerator;

    ShardingUpsertExecutor(ClusterService clusterService, BiConsumer<PartitionName, IndexItem> constraintsChecker, NodeLimits nodeJobsCounter, CircuitBreaker queryCircuitBreaker, RamAccounting ramAccounting, ScheduledExecutorService scheduler, Executor executor, int bulkSize, UUID jobId, RowShardResolver rowShardResolver, ItemFactory<ShardUpsertRequest.Item> itemFactory, Function<ShardId, ShardUpsertRequest> requestFactory, List<? extends CollectExpression<Row, ?>> expressions, Supplier<PartitionName> partitionResolver, boolean autoCreateIndices, Client elasticsearchClient, int targetTableNumShards, int targetTableNumReplicas, UpsertResultContext upsertResultContext, Predicate<UpsertResults> earlyTerminationCondition, Function<UpsertResults, Throwable> earlyTerminationExceptionGenerator) {
        this.localNode = clusterService.state().nodes().getLocalNodeId();
        this.nodeLimits = nodeJobsCounter;
        this.queryCircuitBreaker = queryCircuitBreaker;
        this.scheduler = scheduler;
        this.executor = executor;
        this.bulkSize = bulkSize;
        this.jobId = jobId;
        this.requestFactory = requestFactory;
        this.requestExecutor = (req, resp) -> elasticsearchClient.execute(ShardUpsertAction.INSTANCE, req).whenComplete((BiConsumer)resp);
        this.elasticsearchClient = elasticsearchClient;
        this.ramAccounting = new BlockBasedRamAccounting(arg_0 -> ((RamAccounting)ramAccounting).addBytes(arg_0), (int)ByteSizeUnit.MB.toBytes(2L));
        this.grouper = new GroupRowsByShard(clusterService, constraintsChecker, rowShardResolver, partitionResolver, expressions, itemFactory, autoCreateIndices, upsertResultContext);
        this.bulkShardCreationLimiter = new BulkShardCreationLimiter(targetTableNumShards, targetTableNumReplicas, clusterService.state().nodes().getDataNodes().size());
        this.resultCollector = upsertResultContext.getResultCollector();
        this.isDebugEnabled = LOGGER.isDebugEnabled();
        this.earlyTerminationCondition = earlyTerminationCondition;
        this.earlyTerminationExceptionGenerator = earlyTerminationExceptionGenerator;
    }

    public CompletableFuture<UpsertResults> execute(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests) {
        UpsertResults upsertResults = this.resultCollector.supplier().get();
        ShardingUpsertExecutor.collectFailingSourceUris(requests, upsertResults);
        ShardingUpsertExecutor.collectFailingItems(requests, upsertResults);
        if (requests.itemsByMissingPartition.isEmpty()) {
            return this.execRequests(requests, upsertResults);
        }
        this.createPartitionsRequestOngoing = true;
        return this.elasticsearchClient.execute(TransportCreatePartitions.ACTION, CreatePartitionsRequest.of(requests.itemsByMissingPartition.keySet())).thenCompose(resp -> {
            this.grouper.reResolveShardLocations(requests);
            this.createPartitionsRequestOngoing = false;
            return this.execRequests(requests, upsertResults);
        });
    }

    private static void collectFailingSourceUris(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests, UpsertResults upsertResults) {
        for (Map.Entry<String, String> entry : requests.sourceUrisWithFailure.entrySet()) {
            upsertResults.addUriFailure(entry.getKey(), entry.getValue());
        }
    }

    private static void collectFailingItems(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests, UpsertResults upsertResults) {
        for (Map.Entry<String, List<ShardedRequests.ReadFailureAndLineNumber>> entry : requests.itemsWithFailureBySourceUri.entrySet()) {
            String sourceUri = entry.getKey();
            for (ShardedRequests.ReadFailureAndLineNumber readFailureAndLineNumber : entry.getValue()) {
                upsertResults.addResult(sourceUri, readFailureAndLineNumber.readFailure, readFailureAndLineNumber.lineNumber);
            }
        }
    }

    private CompletableFuture<UpsertResults> execRequests(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests, UpsertResults upsertResults) {
        if (requests.itemsByShard.isEmpty()) {
            requests.close();
            return CompletableFuture.completedFuture(upsertResults);
        }
        AtomicInteger numRequests = new AtomicInteger(requests.itemsByShard.size());
        AtomicReference<Object> interrupt = new AtomicReference<Object>(null);
        CompletableFuture<UpsertResults> resultFuture = new CompletableFuture<UpsertResults>();
        Iterator it = requests.itemsByShard.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ShardUpsertRequest request = (ShardUpsertRequest)entry.getValue();
            it.remove();
            String nodeId = entry.getKey().nodeId;
            ConcurrencyLimit nodeLimit = this.nodeLimits.get(nodeId);
            ShardResponseActionListener listener = new ShardResponseActionListener(this, numRequests, interrupt, upsertResults, this.resultCollector.accumulator(), requests.rowSourceInfos, nodeLimit, resultFuture);
            RetryableAction<ShardResponse> retryableAction = RetryableAction.of(this.scheduler, l -> this.requestExecutor.execute(request, (ActionListener<ShardResponse>)l), BackoffPolicy.unlimitedDynamic(nodeLimit), listener);
            retryableAction.run();
        }
        return resultFuture.whenComplete((r, err) -> requests.close());
    }

    private boolean shouldPauseOnTargetNodeJobsCounter(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> requests) {
        for (ShardLocation shardLocation : requests.itemsByShard.keySet()) {
            String requestNodeId = shardLocation.nodeId;
            ConcurrencyLimit nodeLimit = this.nodeLimits.get(requestNodeId);
            if (!nodeLimit.exceedsLimit()) continue;
            if (this.isDebugEnabled) {
                LOGGER.debug("reached maximum concurrent operations for node {} (limit={}, rrt={}ms, inflight={})", (Object)requestNodeId, (Object)nodeLimit.getLimit(), (Object)nodeLimit.getLastRtt(TimeUnit.MILLISECONDS), (Object)nodeLimit.numInflight());
            }
            return true;
        }
        return false;
    }

    private boolean shouldPauseOnPartitionCreation(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> ignore) {
        if (this.createPartitionsRequestOngoing) {
            if (this.isDebugEnabled) {
                LOGGER.debug("partition creation in progress, will pause");
            }
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<? extends Iterable<Row>> apply(BatchIterator<Row> batchIterator) {
        ConcurrencyLimit nodeLimit = this.nodeLimits.get(this.localNode);
        long startTime = nodeLimit.startSample();
        IsUsedBytesOverThreshold isUsedBytesOverThreshold = new IsUsedBytesOverThreshold(this.queryCircuitBreaker, nodeLimit);
        BatchIterator reqBatchIterator = BatchIterators.chunks(batchIterator, (int)this.bulkSize, () -> new ShardedRequests(this.requestFactory, (RamAccounting)this.ramAccounting), this.grouper, this.bulkShardCreationLimiter.or(isUsedBytesOverThreshold));
        Predicate<ShardedRequests> shouldPause = this::shouldPauseOnPartitionCreation;
        if (batchIterator.hasLazyResultSet()) {
            shouldPause = shouldPause.or(this::shouldPauseOnTargetNodeJobsCounter).or(isUsedBytesOverThreshold);
        }
        BatchIteratorBackpressureExecutor<ShardedRequests, UpsertResults> executor = new BatchIteratorBackpressureExecutor<ShardedRequests, UpsertResults>(this.jobId, this.scheduler, this.executor, reqBatchIterator, this::execute, this.resultCollector.combiner(), this.resultCollector.supplier().get(), shouldPause, this.earlyTerminationCondition, this.earlyTerminationExceptionGenerator, this::getMaxLastRttInMs);
        return ((CompletableFuture)executor.consumeIteratorAndExecute().thenApply(upsertResults -> this.resultCollector.finisher().apply((UpsertResults)upsertResults))).whenComplete((res, err) -> nodeLimit.onSample(startTime));
    }

    private long getMaxLastRttInMs(ShardedRequests<ShardUpsertRequest, ShardUpsertRequest.Item> req) {
        long rtt = 0L;
        for (ShardLocation shardLocation : req.itemsByShard.keySet()) {
            String nodeId = shardLocation.nodeId;
            rtt = Math.max(rtt, this.nodeLimits.get(nodeId).getLastRtt(TimeUnit.MILLISECONDS));
        }
        return rtt;
    }

    private class ShardResponseActionListener
    implements ActionListener<ShardResponse> {
        private final UpsertResultCollector.Accumulator resultAccumulator;
        private final List<RowSourceInfo> rowSourceInfos;
        private final UpsertResults upsertResults;
        private final AtomicInteger numRequests;
        private final AtomicReference<Exception> interrupt;
        private final CompletableFuture<UpsertResults> upsertResultFuture;
        private final ConcurrencyLimit nodeLimit;
        private final long startTime;

        ShardResponseActionListener(ShardingUpsertExecutor shardingUpsertExecutor, AtomicInteger numRequests, AtomicReference<Exception> interrupt, UpsertResults upsertResults, UpsertResultCollector.Accumulator resultAccumulator, List<RowSourceInfo> rowSourceInfos, ConcurrencyLimit nodeLimit, CompletableFuture<UpsertResults> upsertResultFuture) {
            this.numRequests = numRequests;
            this.interrupt = interrupt;
            this.upsertResults = upsertResults;
            this.resultAccumulator = resultAccumulator;
            this.rowSourceInfos = rowSourceInfos;
            this.nodeLimit = nodeLimit;
            this.startTime = nodeLimit.startSample();
            this.upsertResultFuture = upsertResultFuture;
        }

        @Override
        public void onResponse(ShardResponse shardResponse) {
            this.nodeLimit.onSample(this.startTime);
            this.resultAccumulator.accept(this.upsertResults, shardResponse, this.rowSourceInfos);
            Exception failure = shardResponse.failure();
            if (failure != null) {
                this.interrupt.set(failure);
            }
            this.countdown();
        }

        @Override
        public void onFailure(Exception e) {
            this.nodeLimit.onSample(this.startTime);
            this.countdown();
        }

        private void countdown() {
            if (this.numRequests.decrementAndGet() == 0) {
                Exception interruptedException = this.interrupt.get();
                if (interruptedException == null) {
                    this.upsertResultFuture.complete(this.upsertResults);
                } else {
                    this.upsertResultFuture.completeExceptionally(interruptedException);
                }
            }
        }
    }
}

