/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.Streamer;
import io.crate.common.annotations.GuardedBy;
import io.crate.data.BatchIterator;
import io.crate.data.Bucket;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.engine.distribution.merge.BatchPagingIterator;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.PageResultListener;
import io.netty.util.collection.IntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.concurrent.PriorityRunnable;
import org.jetbrains.annotations.NotNull;

public class CumulativePageBucketReceiver
implements PageBucketReceiver {
    private static final Logger LOGGER = LogManager.getLogger(CumulativePageBucketReceiver.class);
    private static final Priority PRIORITY = Priority.HIGH;
    private final Object lock = new Object();
    private final String nodeName;
    private final boolean traceEnabled;
    private final int phaseId;
    private final Executor executor;
    private final Streamer<?>[] streamers;
    private final int numBuckets;
    @GuardedBy(value="lock")
    private final Set<Integer> exhausted;
    private final Map<Integer, PageResultListener> listenersByBucketIdx;
    @GuardedBy(value="lock")
    private final Map<Integer, Bucket> bucketsByIdx;
    private final RowConsumer consumer;
    private final PagingIterator<Integer, Row> pagingIterator;
    private final BatchIterator<Row> batchPagingIterator;
    private final CompletableFuture<?> processingFuture = new CompletableFuture();
    private Throwable lastThrowable = null;
    private volatile CompletableFuture<List<KeyIterable<Integer, Row>>> currentPage = new CompletableFuture();
    private volatile boolean receivingFirstPage = true;

    public CumulativePageBucketReceiver(String nodeName, int phaseId, Executor executor, Streamer<?>[] streamers, RowConsumer rowConsumer, PagingIterator<Integer, Row> pagingIterator, int numBuckets) {
        this.nodeName = nodeName;
        this.phaseId = phaseId;
        this.executor = executor;
        this.streamers = streamers;
        this.consumer = rowConsumer;
        this.pagingIterator = pagingIterator;
        this.numBuckets = numBuckets;
        this.exhausted = Collections.newSetFromMap(new IntObjectHashMap(numBuckets));
        this.bucketsByIdx = new IntObjectHashMap(numBuckets);
        this.listenersByBucketIdx = new IntObjectHashMap(numBuckets);
        this.processingFuture.whenComplete((result, ex) -> {
            Map<Integer, PageResultListener> map = this.listenersByBucketIdx;
            synchronized (map) {
                for (PageResultListener resultListener : this.listenersByBucketIdx.values()) {
                    resultListener.needMore(false);
                }
                this.listenersByBucketIdx.clear();
            }
        });
        this.batchPagingIterator = new BatchPagingIterator<Integer>(pagingIterator, this::fetchMore, this::allUpstreamsExhausted, throwable -> {
            if (throwable == null) {
                this.processingFuture.complete(null);
            } else {
                this.processingFuture.completeExceptionally((Throwable)throwable);
            }
        });
        this.traceEnabled = LOGGER.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBucket(int bucketIdx, Bucket rows, boolean isLast, PageResultListener pageResultListener) {
        boolean allBucketsOfPageReceived;
        boolean isLastOrHasError;
        Map<Integer, PageResultListener> map = this.listenersByBucketIdx;
        synchronized (map) {
            boolean bl = isLastOrHasError = isLast || this.lastThrowable != null;
            if (!isLastOrHasError) {
                this.listenersByBucketIdx.put(bucketIdx, pageResultListener);
            }
        }
        if (isLastOrHasError) {
            pageResultListener.needMore(false);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.traceEnabled) {
                LOGGER.trace("method=setBucket phaseId={} bucket={} istLast={}", (Object)this.phaseId, (Object)bucketIdx, (Object)isLast);
            }
            if (this.bucketsByIdx.putIfAbsent(bucketIdx, rows) != null) {
                this.processingFuture.completeExceptionally(new IllegalStateException(String.format(Locale.ENGLISH, "Same bucket of a page set more than once. node=%s method=setBucket phaseId=%d bucket=%d", this.nodeName, this.phaseId, bucketIdx)));
            }
            if (isLast) {
                this.exhausted.add(bucketIdx);
            }
            allBucketsOfPageReceived = this.bucketsByIdx.size() == this.numBuckets;
        }
        if (allBucketsOfPageReceived) {
            this.processPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerConsumerOrPageFuture(List<KeyIterable<Integer, Row>> buckets) {
        Throwable throwable;
        boolean invokeConsumer = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.receivingFirstPage) {
                this.receivingFirstPage = false;
                invokeConsumer = true;
            }
            throwable = this.lastThrowable;
        }
        Throwable error = throwable;
        if (invokeConsumer) {
            if (error == null) {
                try {
                    this.pagingIterator.merge(buckets);
                    PrioritizedRunnable runnable = PriorityRunnable.of(PRIORITY, "pageBucketReceiver", this::consumeRows);
                    this.executor.execute(runnable);
                }
                catch (Throwable e) {
                    this.consumer.accept(null, e);
                    throwable = e;
                }
            } else {
                this.consumer.accept(null, error);
            }
        } else if (error == null) {
            try {
                PrioritizedRunnable runnable = PriorityRunnable.of(PRIORITY, "pageBucketReceiver", () -> this.currentPage.complete(buckets));
                this.executor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                this.currentPage.completeExceptionally(e);
                throwable = e;
            }
        } else {
            this.currentPage.completeExceptionally(error);
        }
        if (throwable != null) {
            this.processingFuture.completeExceptionally(throwable);
        }
    }

    private void processPage() {
        List<KeyIterable<Integer, Row>> buckets;
        try {
            buckets = this.getBuckets();
        }
        catch (Throwable t) {
            this.kill(t);
            this.currentPage.completeExceptionally(t);
            return;
        }
        if (this.allUpstreamsExhausted()) {
            this.pagingIterator.finish();
        }
        this.triggerConsumerOrPageFuture(buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyIterable<Integer, Row>> getBuckets() {
        ArrayList<KeyIterable<Integer, Row>> buckets = new ArrayList<KeyIterable<Integer, Row>>(this.numBuckets);
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Integer, Bucket>> entryIt = this.bucketsByIdx.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry<Integer, Bucket> entry = entryIt.next();
                Integer bucketIdx = entry.getKey();
                buckets.add(new KeyIterable(bucketIdx, (Iterable)entry.getValue()));
                if (this.exhausted.contains(bucketIdx)) {
                    entry.setValue(Bucket.EMPTY);
                    continue;
                }
                entryIt.remove();
            }
        }
        return buckets;
    }

    private boolean allUpstreamsExhausted() {
        return this.exhausted.size() == this.numBuckets;
    }

    private CompletionStage<? extends Iterable<? extends KeyIterable<Integer, Row>>> fetchMore(Integer exhaustedBucket) {
        if (this.allUpstreamsExhausted()) {
            return CompletableFuture.failedStage(new IllegalStateException("Source is exhausted"));
        }
        this.currentPage = new CompletableFuture();
        if (exhaustedBucket == null || this.exhausted.contains(exhaustedBucket)) {
            this.fetchFromUnExhausted();
        } else {
            this.fetchExhausted(exhaustedBucket);
        }
        return this.currentPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchExhausted(Integer exhaustedBucket) {
        Map<Integer, PageResultListener> map = this.listenersByBucketIdx;
        synchronized (map) {
            PageResultListener pageResultListener = this.listenersByBucketIdx.remove(exhaustedBucket);
            for (Integer bucketIdx : this.listenersByBucketIdx.keySet()) {
                this.bucketsByIdx.putIfAbsent(bucketIdx, Bucket.EMPTY);
            }
            pageResultListener.needMore(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFromUnExhausted() {
        Map<Integer, PageResultListener> map = this.listenersByBucketIdx;
        synchronized (map) {
            for (PageResultListener listener : this.listenersByBucketIdx.values()) {
                listener.needMore(true);
            }
            this.listenersByBucketIdx.clear();
        }
    }

    @Override
    public Streamer<?>[] streamers() {
        return this.streamers;
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.processingFuture;
    }

    @Override
    public void consumeRows() {
        this.consumer.accept(this.batchPagingIterator, this.lastThrowable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(@NotNull Throwable t) {
        boolean shouldTriggerConsumer = false;
        Object object = this.lock;
        synchronized (object) {
            this.lastThrowable = t;
            this.batchPagingIterator.kill(t);
            this.currentPage.completeExceptionally(t);
            if (this.receivingFirstPage) {
                this.receivingFirstPage = false;
                shouldTriggerConsumer = true;
            }
        }
        if (shouldTriggerConsumer) {
            this.consumer.accept(null, t);
        }
    }

    public String toString() {
        return "CumulativePageBucketReceiver{nodeName='" + this.nodeName + "', phaseId=" + this.phaseId + ", numBuckets=" + this.numBuckets + ", consumer=" + String.valueOf(this.consumer) + "}";
    }
}

