/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillAllRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.jobs.kill.TransportKillNodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportKillAllNodeAction
extends TransportAction<KillAllRequest, KillResponse> {
    protected final TasksService tasksService;
    protected final ClusterService clusterService;
    protected final TransportService transportService;

    @Inject
    public TransportKillAllNodeAction(TasksService tasksService, ClusterService clusterService, TransportService transportService) {
        super("internal:crate:sql/kill/all");
        this.tasksService = tasksService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        transportService.registerRequestHandler("internal:crate:sql/kill/all", "generic", KillAllRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    @Override
    public void doExecute(KillAllRequest request, ActionListener<KillResponse> listener) {
        TransportKillNodeAction.broadcast(this.clusterService, this.transportService, request, "internal:crate:sql/kill/all", listener, List.of());
    }

    public CompletableFuture<KillResponse> nodeOperation(KillAllRequest request) {
        return this.tasksService.killAll(request.userName()).thenApply(KillResponse::new);
    }
}

