/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.concurrent.MultiActionListener;
import io.crate.execution.jobs.kill.KillResponse;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public final class TransportKillNodeAction {
    private TransportKillNodeAction() {
    }

    static <T extends TransportRequest> void broadcast(ClusterService clusterService, TransportService transportService, T request, String actionName, ActionListener<KillResponse> listener, Collection<String> excludedNodeIds) {
        Stream<DiscoveryNode> nodes = StreamSupport.stream(clusterService.state().nodes().spliterator(), false);
        Collection filteredNodes = nodes.filter(node -> !excludedNodeIds.contains(node.getId())).collect(Collectors.toList());
        MultiActionListener<KillResponse, Long, KillResponse> multiListener = new MultiActionListener<KillResponse, Long, KillResponse>(filteredNodes.size(), () -> 0L, (state, response) -> {
            state = state + response.numKilled();
        }, KillResponse::new, listener);
        ActionListenerResponseHandler<KillResponse> responseHandler = new ActionListenerResponseHandler<KillResponse>(actionName, multiListener, KillResponse::new);
        for (DiscoveryNode node2 : filteredNodes) {
            transportService.sendRequest(node2, actionName, request, responseHandler);
        }
    }
}

