/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.transport;

import io.crate.common.concurrent.CompletableFutures;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.jobs.InstrumentedIndexSearcher;
import io.crate.execution.jobs.JobSetup;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.transport.JobRequest;
import io.crate.execution.jobs.transport.JobResponse;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.NodeRequest;
import io.crate.execution.support.Transports;
import io.crate.metadata.IndexUUID;
import io.crate.metadata.upgrade.NodeOperationsUpgrader;
import io.crate.profile.ProfilingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportJobAction
extends TransportAction<NodeRequest<JobRequest>, JobResponse> {
    private final IndicesService indicesService;
    private final Transports transports;
    private final TasksService tasksService;
    private final JobSetup jobSetup;
    private final ClusterService clusterService;

    @Inject
    public TransportJobAction(TransportService transportService, IndicesService indicesService, Transports transports, TasksService tasksService, JobSetup jobSetup, ClusterService clusterService) {
        super("internal:crate:sql/job");
        this.indicesService = indicesService;
        this.transports = transports;
        this.tasksService = tasksService;
        this.jobSetup = jobSetup;
        this.clusterService = clusterService;
        transportService.registerRequestHandler("internal:crate:sql/job", "search", JobRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    @Override
    public void doExecute(NodeRequest<JobRequest> request, ActionListener<JobResponse> listener) {
        String nodeId = request.nodeId();
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNode receiverNode = clusterState.nodes().get(nodeId);
        if (receiverNode == null) {
            listener.onFailure(new IllegalArgumentException("Unknown node: " + nodeId));
            return;
        }
        Version receiverVersion = receiverNode.getVersion();
        if (receiverVersion.before(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            JobRequest jobRequest = request.innerRequest();
            request = JobRequest.of(nodeId, jobRequest.jobId(), jobRequest.sessionSettings(), jobRequest.coordinatorNodeId(), NodeOperationsUpgrader.downgrade(jobRequest.nodeOperations(), receiverVersion, clusterState.metadata()), jobRequest.enableProfiling());
        }
        this.transports.sendRequest("internal:crate:sql/job", nodeId, request.innerRequest(), listener, new ActionListenerResponseHandler<JobResponse>("internal:crate:sql/job", listener, JobResponse::new));
    }

    private CompletableFuture<JobResponse> nodeOperation(JobRequest request) {
        CompletableFuture<Void> startFuture;
        RootTask.Builder contextBuilder = this.tasksService.newBuilder(request.jobId(), request.sessionSettings().userName(), request.coordinatorNodeId(), Collections.emptySet());
        SharedShardContexts sharedShardContexts = this.maybeInstrumentProfiler(request.enableProfiling(), contextBuilder);
        Collection<? extends NodeOperation> nodeOperations = NodeOperationsUpgrader.upgrade(request.nodeOperations(), request.senderVersion(), this.clusterService.state().metadata());
        List<CompletableFuture<StreamBucket>> directResponseFutures = this.jobSetup.prepareOnRemote(request.sessionSettings(), nodeOperations, contextBuilder, sharedShardContexts);
        try {
            RootTask context = this.tasksService.createTask(contextBuilder);
            startFuture = context.start();
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
        if (directResponseFutures.size() == 0) {
            return startFuture.thenApply(ignored -> new JobResponse(List.of()));
        }
        return ((CompletableFuture)startFuture.thenCompose(ignored -> CompletableFutures.allAsList((Collection)directResponseFutures))).thenApply(JobResponse::new);
    }

    private SharedShardContexts maybeInstrumentProfiler(boolean enableProfiling, RootTask.Builder contextBuilder) {
        if (enableProfiling) {
            HashMap<ShardId, QueryProfiler> profilers = new HashMap<ShardId, QueryProfiler>();
            ProfilingContext profilingContext = new ProfilingContext(profilers, this.clusterService.state());
            contextBuilder.profilingContext(profilingContext);
            return new SharedShardContexts(this.indicesService, (shardId, indexSearcher) -> {
                QueryProfiler queryProfiler = new QueryProfiler();
                profilers.put((ShardId)shardId, queryProfiler);
                return new InstrumentedIndexSearcher((Engine.Searcher)indexSearcher, queryProfiler);
            });
        }
        return new SharedShardContexts(this.indicesService, (ignored, indexSearcher) -> indexSearcher);
    }
}

