/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.jetbrains.annotations.NotNull;

public class OneRowActionListener<Response>
implements ActionListener<Response>,
BiConsumer<Response, Throwable> {
    private final RowConsumer consumer;
    private final Function<? super Response, ? extends Row> toRowFunction;

    public static OneRowActionListener<? super AcknowledgedResponse> oneIfAcknowledged(RowConsumer consumer) {
        return new OneRowActionListener<AcknowledgedResponse>(consumer, resp -> resp.isAcknowledged() ? new Row1((Object)1L) : new Row1((Object)0L));
    }

    public OneRowActionListener(RowConsumer consumer, Function<? super Response, ? extends Row> toRowFunction) {
        this.consumer = consumer;
        this.toRowFunction = toRowFunction;
    }

    @Override
    public void onResponse(Response response) {
        Row row;
        try {
            row = this.toRowFunction.apply(response);
        }
        catch (Throwable t) {
            this.consumer.accept(null, t);
            return;
        }
        this.consumer.accept(InMemoryBatchIterator.of((Object)row, (Object)SentinelRow.SENTINEL), null);
    }

    @Override
    public void onFailure(@NotNull Exception e) {
        this.consumer.accept(null, (Throwable)e);
    }

    @Override
    public void accept(Response response, Throwable t) {
        if (t == null) {
            this.onResponse(response);
        } else {
            this.consumer.accept(null, t);
        }
    }
}

