/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.symbol.Literal;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.network.InetAddresses;

public final class CIDROperator {
    public static final String CONTAINED_WITHIN = "op_<<";

    private CIDROperator() {
    }

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(CONTAINED_WITHIN, FunctionType.SCALAR).argumentTypes(DataTypes.IP.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ContainedWithinOperator::new);
    }

    public static boolean containedWithin(String ipStr, String cidrStr) {
        if (null == ipStr || null == cidrStr) {
            throw new IllegalArgumentException("operands cannot be null");
        }
        if (!cidrStr.contains("/") || ipStr.contains("/")) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "operands are incorrect, expected [ip, cidr], got [%s, %s]", ipStr, cidrStr));
        }
        try {
            BigInteger ip = new BigInteger(1, InetAddress.getByName(ipStr).getAddress());
            InetAddresses.InetAddressPrefixLength cidr = InetAddresses.parseCidr(cidrStr);
            InetAddress[] bounds = CIDROperator.obtainBounds(cidr.inetAddress(), cidr.prefixLen());
            BigInteger lower = new BigInteger(1, bounds[0].getAddress());
            BigInteger upper = new BigInteger(1, bounds[1].getAddress());
            return lower.compareTo(ip) <= 0 && ip.compareTo(upper) <= 0;
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe);
        }
    }

    private static InetAddress[] obtainBounds(InetAddress value, int prefixLength) {
        if (prefixLength >= 0 && prefixLength <= 8 * value.getAddress().length) {
            byte[] lower = value.getAddress();
            byte[] upper = value.getAddress();
            for (int i = prefixLength; i < 8 * lower.length; ++i) {
                int m = 1 << 7 - (i & 7);
                lower[i >> 3] = (byte)(lower[i >> 3] & ~m);
                upper[i >> 3] = (byte)(upper[i >> 3] | m);
            }
            try {
                return new InetAddress[]{InetAddress.getByAddress(lower), InetAddress.getByAddress(upper)};
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("illegal prefixLength '" + prefixLength + "'. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges");
    }

    public static class ContainedWithinOperator
    extends Scalar<Boolean, Object> {
        public ContainedWithinOperator(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
            assert (args.length == 2) : "number of args must be 2";
            String left = (String)args[0].value();
            if (null == left) {
                return null;
            }
            String right = (String)args[1].value();
            if (null == right) {
                return null;
            }
            return CIDROperator.containedWithin(left, right);
        }

        @Override
        public Query toQuery(Reference ref, Literal<?> literal) {
            String cidrStr = (String)literal.value();
            InetAddresses.InetAddressPrefixLength cidr = InetAddresses.parseCidr(cidrStr);
            InetAddress[] bounds = CIDROperator.obtainBounds(cidr.inetAddress(), cidr.prefixLen());
            assert (ref.valueType().id() == DataTypes.IP.id()) : "In <ref> << <literal> the ref must have type IP due to function registration";
            EqQuery<String> eqQuery = DataTypes.IP.storageSupportSafe().eqQuery();
            if (eqQuery == null) {
                return null;
            }
            return eqQuery.rangeQuery(ref.storageIdent(), bounds[0].getHostAddress(), bounds[1].getHostAddress(), true, true, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
        }
    }
}

