/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.match.CrateRegexQuery;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;

public class RegexpMatchCaseInsensitiveOperator
extends Operator<String> {
    public static final String NAME = "op_~*";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), RegexpMatchCaseInsensitiveOperator::new);
    }

    public RegexpMatchCaseInsensitiveOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 2) : "invalid number of arguments";
        String source = (String)args[0].value();
        if (source == null) {
            return null;
        }
        String pattern = (String)args[1].value();
        if (pattern == null) {
            return null;
        }
        Pattern p = Pattern.compile(pattern, 66);
        return p.matcher(source).matches();
    }

    @Override
    public Query toQuery(Reference ref, Literal<?> literal) {
        String pattern = (String)literal.value();
        return new CrateRegexQuery(new Term(ref.storageIdent(), pattern), 66);
    }
}

