/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.all;

import io.crate.execution.dml.ArrayIndexer;
import io.crate.expression.operator.EqOperator;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.all.AllOperator;
import io.crate.expression.operator.any.AnyNeqOperator;
import io.crate.expression.predicate.NotPredicate;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.types.ArrayType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;

public final class AllEqOperator
extends AllOperator<Object> {
    public static final String NAME = "_all_" + ComparisonExpression.Type.EQUAL.getValue();

    public AllEqOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    boolean matches(Object probe, Object candidate) {
        return this.leftType.compare(probe, candidate) == 0;
    }

    @Override
    protected Query refMatchesAllArrayLiteral(Function all, Reference probe, Literal<?> literal, LuceneQueryBuilder.Context context) {
        Set uniqueValues = StreamSupport.stream(((Iterable)literal.value()).spliterator(), false).collect(Collectors.toSet());
        if (uniqueValues.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        if (uniqueValues.contains(null)) {
            return new MatchNoDocsQuery("If the array literal contains nulls, it is either false or null; hence a no-match");
        }
        if (uniqueValues.size() > 1) {
            return new MatchNoDocsQuery("A single value cannot match more than one unique values");
        }
        Object value = uniqueValues.iterator().next();
        return EqOperator.fromPrimitive(probe.valueType(), probe.storageIdent(), value, probe.hasDocValues(), probe.indexType());
    }

    @Override
    protected Query literalMatchesAllArrayRef(Function allEq, Literal<?> literal, Reference ref, LuceneQueryBuilder.Context context) {
        if (ArrayType.dimensions(ref.valueType()) == 1 && context.tableInfo().versionCreated().onOrAfter(ArrayIndexer.ARRAY_LENGTH_FIELD_SUPPORTED_VERSION)) {
            Query anyNeq;
            Query arraysWithoutNullElementsQuery = ArrayIndexer.arraysWithoutNullElementsQuery(ref, context.tableInfo()::getReference);
            if (arraysWithoutNullElementsQuery != null && (anyNeq = AnyNeqOperator.literalMatchesAnyArrayRef(literal, ref)) != null) {
                Query doesNotContainValuesOtherThanLiteral = Queries.not(anyNeq);
                Query emptyArrays = ArrayIndexer.arrayLengthTermQuery(ref, 0, context.tableInfo()::getReference);
                return new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add((Query)new BooleanQuery.Builder().add(arraysWithoutNullElementsQuery, BooleanClause.Occur.MUST).add(doesNotContainValuesOtherThanLiteral, BooleanClause.Occur.MUST).build(), BooleanClause.Occur.SHOULD).add(emptyArrays, BooleanClause.Occur.SHOULD).build();
            }
        }
        Function notAnyNeq = new Function(NotPredicate.SIGNATURE, List.of(new Function(AnyNeqOperator.SIGNATURE, allEq.arguments(), Operator.RETURN_TYPE)), Operator.RETURN_TYPE);
        return context.visitor().visitFunction(notAnyNeq, context);
    }
}

