/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.expression.operator.LikeOperators;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public final class AnyLikeOperator
extends AnyOperator<String> {
    private final LikeOperators.CaseSensitivity caseSensitivity;

    public AnyLikeOperator(Signature signature, BoundSignature boundSignature, LikeOperators.CaseSensitivity caseSensitivity) {
        super(signature, boundSignature);
        this.caseSensitivity = caseSensitivity;
        DataType innerType = ((ArrayType)boundSignature.argTypes().get(1)).innerType();
        if (innerType.id() == 12) {
            throw new IllegalArgumentException("ANY on object arrays is not supported");
        }
    }

    @Override
    boolean matches(String probe, String candidate) {
        return LikeOperators.matches(probe, candidate, LikeOperators.DEFAULT_ESCAPE, this.caseSensitivity);
    }

    @Override
    protected Query refMatchesAnyArrayLiteral(Function any, Reference probe, Literal<?> candidates, LuceneQueryBuilder.Context context) {
        if (ArrayType.dimensions(candidates.valueType()) > 1) {
            return null;
        }
        List<?> nonNullValues = AnyLikeOperator.filterNullValues(candidates);
        if (nonNullValues.isEmpty()) {
            return new MatchNoDocsQuery("Cannot match unless there is at least one non-null candidate");
        }
        String fqn = probe.storageIdent();
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        booleanQuery.setMinimumNumberShouldMatch(1);
        for (Object value : nonNullValues) {
            Query likeQuery = this.caseSensitivity.likeQuery(fqn, (String)value, LikeOperators.DEFAULT_ESCAPE, probe.indexType() != IndexType.NONE);
            if (likeQuery == null) {
                return null;
            }
            booleanQuery.add(likeQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery.build();
    }

    @Override
    protected Query literalMatchesAnyArrayRef(Function any, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        return null;
    }

    @Override
    protected void validateRightArg(String arg) {
        if (arg.endsWith("\\")) {
            LikeOperators.throwErrorForTrailingEscapeChar(arg, LikeOperators.DEFAULT_ESCAPE);
        }
    }
}

